package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface AuthenticationStatusFluent<A extends AuthenticationStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A addToGenerations(int index,GenerationStatus item);
    public A setToGenerations(int index,GenerationStatus item);
    public A addToGenerations(GenerationStatus... items);
    public A addAllToGenerations(Collection<GenerationStatus> items);
    public A removeFromGenerations(GenerationStatus... items);
    public A removeAllFromGenerations(Collection<GenerationStatus> items);
    public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations();
    public List<GenerationStatus> buildGenerations();
    public GenerationStatus buildGeneration(int index);
    public GenerationStatus buildFirstGeneration();
    public GenerationStatus buildLastGeneration();
    public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public A withGenerations(List<GenerationStatus> generations);
    public A withGenerations(GenerationStatus... generations);
    public Boolean hasGenerations();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> addNewGeneration();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> editGeneration(int index);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> editFirstGeneration();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> editLastGeneration();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Boolean getManagingOAuthAPIServer();
    public A withManagingOAuthAPIServer(Boolean managingOAuthAPIServer);
    public Boolean hasManagingOAuthAPIServer();
    public A withNewManagingOAuthAPIServer(String arg1);
    public A withNewManagingOAuthAPIServer(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildOauthAPIServer instead.
 * @return The buildable object.
 */
@Deprecated public OAuthAPIServerStatus getOauthAPIServer();
    public OAuthAPIServerStatus buildOauthAPIServer();
    public A withOauthAPIServer(OAuthAPIServerStatus oauthAPIServer);
    public Boolean hasOauthAPIServer();
    public A withNewOauthAPIServer(Integer latestAvailableRevision);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<A> withNewOauthAPIServer();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<A> withNewOauthAPIServerLike(OAuthAPIServerStatus item);
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<A> editOauthAPIServer();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<A> editOrNewOauthAPIServer();
    public io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<A> editOrNewOauthAPIServerLike(OAuthAPIServerStatus item);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg0);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface GenerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenerationStatusFluent<io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.GenerationsNested<N>> {

            public N and();
            public N endGeneration();    }


    public interface OauthAPIServerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAPIServerStatusFluent<io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluent.OauthAPIServerNested<N>> {

            public N and();
            public N endOauthAPIServer();    }


}
