package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceFluentImpl;

public class ConsoleCustomizationFluentImpl<A extends ConsoleCustomizationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleCustomizationFluent<A> {

    private String brand;
    private ConfigMapFileReferenceBuilder customLogoFile;
    private String customProductName;
    private String documentationBaseURL;

    public ConsoleCustomizationFluentImpl() {
    }

    public ConsoleCustomizationFluentImpl(ConsoleCustomization instance) {
        this.withBrand(instance.getBrand()); 
        this.withCustomLogoFile(instance.getCustomLogoFile()); 
        this.withCustomProductName(instance.getCustomProductName()); 
        this.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
    }

    public String getBrand() {
        return this.brand;
    }

    public A withBrand(String brand) {
        this.brand=brand; return (A) this;
    }

    public Boolean hasBrand() {
        return this.brand != null;
    }

    public A withNewBrand(StringBuilder arg1) {
        return (A)withBrand(new String(arg1));
    }

    public A withNewBrand(int[] arg1,int arg2,int arg3) {
        return (A)withBrand(new String(arg1, arg2, arg3));
    }

    public A withNewBrand(char[] arg1) {
        return (A)withBrand(new String(arg1));
    }

    public A withNewBrand(StringBuffer arg1) {
        return (A)withBrand(new String(arg1));
    }

    public A withNewBrand(byte[] arg1,int arg2) {
        return (A)withBrand(new String(arg1, arg2));
    }

    public A withNewBrand(byte[] arg1) {
        return (A)withBrand(new String(arg1));
    }

    public A withNewBrand(char[] arg1,int arg2,int arg3) {
        return (A)withBrand(new String(arg1, arg2, arg3));
    }

    public A withNewBrand(byte[] arg1,int arg2,int arg3) {
        return (A)withBrand(new String(arg1, arg2, arg3));
    }

    public A withNewBrand(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBrand(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBrand(String arg1) {
        return (A)withBrand(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCustomLogoFile instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapFileReference getCustomLogoFile() {
        return this.customLogoFile!=null?this.customLogoFile.build():null;
    }

    public ConfigMapFileReference buildCustomLogoFile() {
        return this.customLogoFile!=null?this.customLogoFile.build():null;
    }

    public A withCustomLogoFile(ConfigMapFileReference customLogoFile) {
        _visitables.get("customLogoFile").remove(this.customLogoFile);
        if (customLogoFile!=null){ this.customLogoFile= new ConfigMapFileReferenceBuilder(customLogoFile); _visitables.get("customLogoFile").add(this.customLogoFile);} return (A) this;
    }

    public Boolean hasCustomLogoFile() {
        return this.customLogoFile != null;
    }

    public A withNewCustomLogoFile(String key,String name) {
        return (A)withCustomLogoFile(new ConfigMapFileReference(key, name));
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFile() {
        return new CustomLogoFileNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFileLike(ConfigMapFileReference item) {
        return new CustomLogoFileNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editCustomLogoFile() {
        return withNewCustomLogoFileLike(getCustomLogoFile());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFile() {
        return withNewCustomLogoFileLike(getCustomLogoFile() != null ? getCustomLogoFile(): new ConfigMapFileReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFileLike(ConfigMapFileReference item) {
        return withNewCustomLogoFileLike(getCustomLogoFile() != null ? getCustomLogoFile(): item);
    }

    public String getCustomProductName() {
        return this.customProductName;
    }

    public A withCustomProductName(String customProductName) {
        this.customProductName=customProductName; return (A) this;
    }

    public Boolean hasCustomProductName() {
        return this.customProductName != null;
    }

    public A withNewCustomProductName(StringBuilder arg1) {
        return (A)withCustomProductName(new String(arg1));
    }

    public A withNewCustomProductName(int[] arg1,int arg2,int arg3) {
        return (A)withCustomProductName(new String(arg1, arg2, arg3));
    }

    public A withNewCustomProductName(char[] arg1) {
        return (A)withCustomProductName(new String(arg1));
    }

    public A withNewCustomProductName(StringBuffer arg1) {
        return (A)withCustomProductName(new String(arg1));
    }

    public A withNewCustomProductName(byte[] arg1,int arg2) {
        return (A)withCustomProductName(new String(arg1, arg2));
    }

    public A withNewCustomProductName(byte[] arg1) {
        return (A)withCustomProductName(new String(arg1));
    }

    public A withNewCustomProductName(char[] arg1,int arg2,int arg3) {
        return (A)withCustomProductName(new String(arg1, arg2, arg3));
    }

    public A withNewCustomProductName(byte[] arg1,int arg2,int arg3) {
        return (A)withCustomProductName(new String(arg1, arg2, arg3));
    }

    public A withNewCustomProductName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCustomProductName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCustomProductName(String arg1) {
        return (A)withCustomProductName(new String(arg1));
    }

    public String getDocumentationBaseURL() {
        return this.documentationBaseURL;
    }

    public A withDocumentationBaseURL(String documentationBaseURL) {
        this.documentationBaseURL=documentationBaseURL; return (A) this;
    }

    public Boolean hasDocumentationBaseURL() {
        return this.documentationBaseURL != null;
    }

    public A withNewDocumentationBaseURL(StringBuilder arg1) {
        return (A)withDocumentationBaseURL(new String(arg1));
    }

    public A withNewDocumentationBaseURL(int[] arg1,int arg2,int arg3) {
        return (A)withDocumentationBaseURL(new String(arg1, arg2, arg3));
    }

    public A withNewDocumentationBaseURL(char[] arg1) {
        return (A)withDocumentationBaseURL(new String(arg1));
    }

    public A withNewDocumentationBaseURL(StringBuffer arg1) {
        return (A)withDocumentationBaseURL(new String(arg1));
    }

    public A withNewDocumentationBaseURL(byte[] arg1,int arg2) {
        return (A)withDocumentationBaseURL(new String(arg1, arg2));
    }

    public A withNewDocumentationBaseURL(byte[] arg1) {
        return (A)withDocumentationBaseURL(new String(arg1));
    }

    public A withNewDocumentationBaseURL(char[] arg1,int arg2,int arg3) {
        return (A)withDocumentationBaseURL(new String(arg1, arg2, arg3));
    }

    public A withNewDocumentationBaseURL(byte[] arg1,int arg2,int arg3) {
        return (A)withDocumentationBaseURL(new String(arg1, arg2, arg3));
    }

    public A withNewDocumentationBaseURL(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDocumentationBaseURL(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDocumentationBaseURL(String arg1) {
        return (A)withDocumentationBaseURL(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleCustomizationFluentImpl that = (ConsoleCustomizationFluentImpl) o;
        if (brand != null ? !brand.equals(that.brand) :that.brand != null) return false;
        if (customLogoFile != null ? !customLogoFile.equals(that.customLogoFile) :that.customLogoFile != null) return false;
        if (customProductName != null ? !customProductName.equals(that.customProductName) :that.customProductName != null) return false;
        if (documentationBaseURL != null ? !documentationBaseURL.equals(that.documentationBaseURL) :that.documentationBaseURL != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(brand,  customLogoFile,  customProductName,  documentationBaseURL,  super.hashCode());
    }

    public class CustomLogoFileNestedImpl<N> extends ConfigMapFileReferenceFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigMapFileReferenceBuilder builder;

            CustomLogoFileNestedImpl(ConfigMapFileReference item) {
                this.builder = new ConfigMapFileReferenceBuilder(this, item);
                        
            }

            CustomLogoFileNestedImpl() {
                this.builder = new ConfigMapFileReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleCustomizationFluentImpl.this.withCustomLogoFile(builder.build());
            }

            public N endCustomLogoFile() {
                return and();
            }
    }


}
