package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleProvidersBuilder extends ConsoleProvidersFluentImpl<ConsoleProvidersBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConsoleProviders,ConsoleProvidersBuilder> {

    ConsoleProvidersFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleProvidersBuilder() {
        this(true);
    }

    public ConsoleProvidersBuilder(Boolean validationEnabled) {
        this(new ConsoleProviders(), validationEnabled);
    }

    public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleProviders(), validationEnabled);
    }

    public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,ConsoleProviders instance) {
        this(fluent, instance, true);
    }

    public ConsoleProvidersBuilder(ConsoleProvidersFluent<?> fluent,ConsoleProviders instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatuspage(instance.getStatuspage()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleProvidersBuilder(ConsoleProviders instance) {
        this(instance,true);
    }

    public ConsoleProvidersBuilder(ConsoleProviders instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatuspage(instance.getStatuspage()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleProviders build() {
        ConsoleProviders buildable = new ConsoleProviders(fluent.getStatuspage());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleProvidersBuilder that = (ConsoleProvidersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
