package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleSpecBuilder extends ConsoleSpecFluentImpl<ConsoleSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ConsoleSpec,ConsoleSpecBuilder> {

    ConsoleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleSpecBuilder() {
        this(true);
    }

    public ConsoleSpecBuilder(Boolean validationEnabled) {
        this(new ConsoleSpec(), validationEnabled);
    }

    public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleSpec(), validationEnabled);
    }

    public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance) {
        this(fluent, instance, true);
    }

    public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent,ConsoleSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCustomization(instance.getCustomization()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withProviders(instance.getProviders()); 
        fluent.withRoute(instance.getRoute()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleSpecBuilder(ConsoleSpec instance) {
        this(instance,true);
    }

    public ConsoleSpecBuilder(ConsoleSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCustomization(instance.getCustomization()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withProviders(instance.getProviders()); 
        this.withRoute(instance.getRoute()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleSpec build() {
        ConsoleSpec buildable = new ConsoleSpec(fluent.getCustomization(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getProviders(),fluent.getRoute(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleSpecBuilder that = (ConsoleSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
