package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DNSRecordStatusFluent<A extends DNSRecordStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public A addToZones(int index,DNSZoneStatus item);
    public A setToZones(int index,DNSZoneStatus item);
    public A addToZones(DNSZoneStatus... items);
    public A addAllToZones(Collection<DNSZoneStatus> items);
    public A removeFromZones(DNSZoneStatus... items);
    public A removeAllFromZones(Collection<DNSZoneStatus> items);
    public A removeMatchingFromZones(Predicate<DNSZoneStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildZones instead.
 * @return The buildable object.
 */
@Deprecated public List<DNSZoneStatus> getZones();
    public List<DNSZoneStatus> buildZones();
    public DNSZoneStatus buildZone(int index);
    public DNSZoneStatus buildFirstZone();
    public DNSZoneStatus buildLastZone();
    public DNSZoneStatus buildMatchingZone(Predicate<DNSZoneStatusBuilder> predicate);
    public Boolean hasMatchingZone(Predicate<DNSZoneStatusBuilder> predicate);
    public A withZones(List<DNSZoneStatus> zones);
    public A withZones(DNSZoneStatus... zones);
    public Boolean hasZones();
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> addNewZone();
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> addNewZoneLike(DNSZoneStatus item);
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> setNewZoneLike(int index,DNSZoneStatus item);
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> editZone(int index);
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> editFirstZone();
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> editLastZone();
    public io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<A> editMatchingZone(Predicate<DNSZoneStatusBuilder> predicate);
    public interface ZonesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSZoneStatusFluent<io.fabric8.openshift.api.model.operator.v1.DNSRecordStatusFluent.ZonesNested<N>> {

            public N and();
            public N endZone();    }


}
