package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSZoneConditionBuilder extends DNSZoneConditionFluentImpl<DNSZoneConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DNSZoneCondition,DNSZoneConditionBuilder> {

    DNSZoneConditionFluent<?> fluent;
    Boolean validationEnabled;

    public DNSZoneConditionBuilder() {
        this(true);
    }

    public DNSZoneConditionBuilder(Boolean validationEnabled) {
        this(new DNSZoneCondition(), validationEnabled);
    }

    public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSZoneCondition(), validationEnabled);
    }

    public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,DNSZoneCondition instance) {
        this(fluent, instance, true);
    }

    public DNSZoneConditionBuilder(DNSZoneConditionFluent<?> fluent,DNSZoneCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZoneConditionBuilder(DNSZoneCondition instance) {
        this(instance,true);
    }

    public DNSZoneConditionBuilder(DNSZoneCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSZoneCondition build() {
        DNSZoneCondition buildable = new DNSZoneCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSZoneConditionBuilder that = (DNSZoneConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
