package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EtcdStatusBuilder extends EtcdStatusFluentImpl<EtcdStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<EtcdStatus,EtcdStatusBuilder> {

    EtcdStatusFluent<?> fluent;
    Boolean validationEnabled;

    public EtcdStatusBuilder() {
        this(true);
    }

    public EtcdStatusBuilder(Boolean validationEnabled) {
        this(new EtcdStatus(), validationEnabled);
    }

    public EtcdStatusBuilder(EtcdStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EtcdStatus(), validationEnabled);
    }

    public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,EtcdStatus instance) {
        this(fluent, instance, true);
    }

    public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,EtcdStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
        fluent.withNodeStatuses(instance.getNodeStatuses()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdStatusBuilder(EtcdStatus instance) {
        this(instance,true);
    }

    public EtcdStatusBuilder(EtcdStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
        this.withNodeStatuses(instance.getNodeStatuses()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdStatus build() {
        EtcdStatus buildable = new EtcdStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EtcdStatusBuilder that = (EtcdStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
