package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GenerationStatusBuilder extends GenerationStatusFluentImpl<GenerationStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<GenerationStatus,GenerationStatusBuilder> {

    GenerationStatusFluent<?> fluent;
    Boolean validationEnabled;

    public GenerationStatusBuilder() {
        this(true);
    }

    public GenerationStatusBuilder(Boolean validationEnabled) {
        this(new GenerationStatus(), validationEnabled);
    }

    public GenerationStatusBuilder(GenerationStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new GenerationStatus(), validationEnabled);
    }

    public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance) {
        this(fluent, instance, true);
    }

    public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroup(instance.getGroup()); 
        fluent.withHash(instance.getHash()); 
        fluent.withLastGeneration(instance.getLastGeneration()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withResource(instance.getResource()); 
        this.validationEnabled = validationEnabled; 
    }

    public GenerationStatusBuilder(GenerationStatus instance) {
        this(instance,true);
    }

    public GenerationStatusBuilder(GenerationStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroup(instance.getGroup()); 
        this.withHash(instance.getHash()); 
        this.withLastGeneration(instance.getLastGeneration()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withResource(instance.getResource()); 
        this.validationEnabled = validationEnabled; 
    }

    public GenerationStatus build() {
        GenerationStatus buildable = new GenerationStatus(fluent.getGroup(),fluent.getHash(),fluent.getLastGeneration(),fluent.getName(),fluent.getNamespace(),fluent.getResource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GenerationStatusBuilder that = (GenerationStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
