package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerStatusBuilder extends IngressControllerStatusFluentImpl<IngressControllerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IngressControllerStatus,IngressControllerStatusBuilder> {

    IngressControllerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerStatusBuilder() {
        this(true);
    }

    public IngressControllerStatusBuilder(Boolean validationEnabled) {
        this(new IngressControllerStatus(), validationEnabled);
    }

    public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressControllerStatus(), validationEnabled);
    }

    public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,IngressControllerStatus instance) {
        this(fluent, instance, true);
    }

    public IngressControllerStatusBuilder(IngressControllerStatusFluent<?> fluent,IngressControllerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDomain(instance.getDomain()); 
        fluent.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTlsProfile(instance.getTlsProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerStatusBuilder(IngressControllerStatus instance) {
        this(instance,true);
    }

    public IngressControllerStatusBuilder(IngressControllerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withConditions(instance.getConditions()); 
        this.withDomain(instance.getDomain()); 
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSelector(instance.getSelector()); 
        this.withTlsProfile(instance.getTlsProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerStatus build() {
        IngressControllerStatus buildable = new IngressControllerStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getDomain(),fluent.getEndpointPublishingStrategy(),fluent.getObservedGeneration(),fluent.getSelector(),fluent.getTlsProfile());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerStatusBuilder that = (IngressControllerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
