package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.TLSProfileSpecFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.TLSProfileSpecBuilder;

public interface IngressControllerStatusFluent<A extends IngressControllerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A withNewAvailableReplicas(int arg0);
    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public String getDomain();
    public A withDomain(String domain);
    public Boolean hasDomain();
    public A withNewDomain(StringBuilder arg1);
    public A withNewDomain(int[] arg1,int arg2,int arg3);
    public A withNewDomain(char[] arg1);
    public A withNewDomain(StringBuffer arg1);
    public A withNewDomain(byte[] arg1,int arg2);
    public A withNewDomain(byte[] arg1);
    public A withNewDomain(char[] arg1,int arg2,int arg3);
    public A withNewDomain(byte[] arg1,int arg2,int arg3);
    public A withNewDomain(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDomain(String arg1);
    
/**
 * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
 * @return The buildable object.
 */
@Deprecated public EndpointPublishingStrategy getEndpointPublishingStrategy();
    public EndpointPublishingStrategy buildEndpointPublishingStrategy();
    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy);
    public Boolean hasEndpointPublishingStrategy();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public String getSelector();
    public A withSelector(String selector);
    public Boolean hasSelector();
    public A withNewSelector(StringBuilder arg1);
    public A withNewSelector(int[] arg1,int arg2,int arg3);
    public A withNewSelector(char[] arg1);
    public A withNewSelector(StringBuffer arg1);
    public A withNewSelector(byte[] arg1,int arg2);
    public A withNewSelector(byte[] arg1);
    public A withNewSelector(char[] arg1,int arg2,int arg3);
    public A withNewSelector(byte[] arg1,int arg2,int arg3);
    public A withNewSelector(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSelector(String arg1);
    
/**
 * This method has been deprecated, please use method buildTlsProfile instead.
 * @return The buildable object.
 */
@Deprecated public TLSProfileSpec getTlsProfile();
    public TLSProfileSpec buildTlsProfile();
    public A withTlsProfile(TLSProfileSpec tlsProfile);
    public Boolean hasTlsProfile();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfile();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfileLike(TLSProfileSpec item);
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editTlsProfile();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfile();
    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfileLike(TLSProfileSpec item);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface EndpointPublishingStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointPublishingStrategyFluent<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>> {

            public N and();
            public N endEndpointPublishingStrategy();    }


    public interface TlsProfileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSProfileSpecFluent<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent.TlsProfileNested<N>> {

            public N and();
            public N endTlsProfile();    }


}
