package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeControllerManagerListBuilder extends KubeControllerManagerListFluentImpl<KubeControllerManagerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KubeControllerManagerList,KubeControllerManagerListBuilder> {

    KubeControllerManagerListFluent<?> fluent;
    Boolean validationEnabled;

    public KubeControllerManagerListBuilder() {
        this(true);
    }

    public KubeControllerManagerListBuilder(Boolean validationEnabled) {
        this(new KubeControllerManagerList(), validationEnabled);
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeControllerManagerList(), validationEnabled);
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,KubeControllerManagerList instance) {
        this(fluent, instance, true);
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerListFluent<?> fluent,KubeControllerManagerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerList instance) {
        this(instance,true);
    }

    public KubeControllerManagerListBuilder(KubeControllerManagerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeControllerManagerList build() {
        KubeControllerManagerList buildable = new KubeControllerManagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeControllerManagerListBuilder that = (KubeControllerManagerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
