package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkListBuilder extends NetworkListFluentImpl<NetworkListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NetworkList,NetworkListBuilder> {

    NetworkListFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkListBuilder() {
        this(true);
    }

    public NetworkListBuilder(Boolean validationEnabled) {
        this(new NetworkList(), validationEnabled);
    }

    public NetworkListBuilder(NetworkListFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkListBuilder(NetworkListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NetworkList(), validationEnabled);
    }

    public NetworkListBuilder(NetworkListFluent<?> fluent,NetworkList instance) {
        this(fluent, instance, true);
    }

    public NetworkListBuilder(NetworkListFluent<?> fluent,NetworkList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkListBuilder(NetworkList instance) {
        this(instance,true);
    }

    public NetworkListBuilder(NetworkList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkList build() {
        NetworkList buildable = new NetworkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkListBuilder that = (NetworkListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
