package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToAdditionalNetworks(int index,AdditionalNetworkDefinition item);
    public A setToAdditionalNetworks(int index,AdditionalNetworkDefinition item);
    public A addToAdditionalNetworks(AdditionalNetworkDefinition... items);
    public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
    public A removeFromAdditionalNetworks(AdditionalNetworkDefinition... items);
    public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items);
    public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAdditionalNetworks instead.
 * @return The buildable object.
 */
@Deprecated public List<AdditionalNetworkDefinition> getAdditionalNetworks();
    public List<AdditionalNetworkDefinition> buildAdditionalNetworks();
    public AdditionalNetworkDefinition buildAdditionalNetwork(int index);
    public AdditionalNetworkDefinition buildFirstAdditionalNetwork();
    public AdditionalNetworkDefinition buildLastAdditionalNetwork();
    public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks);
    public A withAdditionalNetworks(AdditionalNetworkDefinition... additionalNetworks);
    public Boolean hasAdditionalNetworks();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index,AdditionalNetworkDefinition item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(int index);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate);
    public A addToClusterNetwork(int index,ClusterNetworkEntry item);
    public A setToClusterNetwork(int index,ClusterNetworkEntry item);
    public A addToClusterNetwork(ClusterNetworkEntry... items);
    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeFromClusterNetwork(ClusterNetworkEntry... items);
    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildClusterNetwork instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getClusterNetwork();
    public List<ClusterNetworkEntry> buildClusterNetwork();
    public ClusterNetworkEntry buildClusterNetwork(int index);
    public ClusterNetworkEntry buildFirstClusterNetwork();
    public ClusterNetworkEntry buildLastClusterNetwork();
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
    public A withClusterNetwork(ClusterNetworkEntry... clusterNetwork);
    public Boolean hasClusterNetwork();
    public A addNewClusterNetwork(String cidr,Integer hostPrefix);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDefaultNetwork instead.
 * @return The buildable object.
 */
@Deprecated public DefaultNetworkDefinition getDefaultNetwork();
    public DefaultNetworkDefinition buildDefaultNetwork();
    public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork);
    public Boolean hasDefaultNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item);
    public Boolean getDeployKubeProxy();
    public A withDeployKubeProxy(Boolean deployKubeProxy);
    public Boolean hasDeployKubeProxy();
    public A withNewDeployKubeProxy(String arg1);
    public A withNewDeployKubeProxy(boolean arg1);
    public Boolean getDisableMultiNetwork();
    public A withDisableMultiNetwork(Boolean disableMultiNetwork);
    public Boolean hasDisableMultiNetwork();
    public A withNewDisableMultiNetwork(String arg1);
    public A withNewDisableMultiNetwork(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildKubeProxyConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getKubeProxyConfig();
    public ProxyConfig buildKubeProxyConfig();
    public A withKubeProxyConfig(ProxyConfig kubeProxyConfig);
    public Boolean hasKubeProxyConfig();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item);
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig();
    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(int[] arg1,int arg2,int arg3);
    public A withNewLogLevel(char[] arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A withNewLogLevel(byte[] arg1,int arg2);
    public A withNewLogLevel(byte[] arg1);
    public A withNewLogLevel(char[] arg1,int arg2,int arg3);
    public A withNewLogLevel(byte[] arg1,int arg2,int arg3);
    public A withNewLogLevel(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogLevel(String arg1);
    public A addToServiceNetwork(int index,String item);
    public A setToServiceNetwork(int index,String item);
    public A addToServiceNetwork(String... items);
    public A addAllToServiceNetwork(Collection<String> items);
    public A removeFromServiceNetwork(String... items);
    public A removeAllFromServiceNetwork(Collection<String> items);
    public List<String> getServiceNetwork();
    public String getServiceNetwork(int index);
    public String getFirstServiceNetwork();
    public String getLastServiceNetwork();
    public String getMatchingServiceNetwork(Predicate<String> predicate);
    public Boolean hasMatchingServiceNetwork(Predicate<String> predicate);
    public A withServiceNetwork(List<String> serviceNetwork);
    public A withServiceNetwork(String... serviceNetwork);
    public Boolean hasServiceNetwork();
    public A addNewServiceNetwork(StringBuilder arg1);
    public A addNewServiceNetwork(int[] arg1,int arg2,int arg3);
    public A addNewServiceNetwork(char[] arg1);
    public A addNewServiceNetwork(StringBuffer arg1);
    public A addNewServiceNetwork(byte[] arg1,int arg2);
    public A addNewServiceNetwork(byte[] arg1);
    public A addNewServiceNetwork(char[] arg1,int arg2,int arg3);
    public A addNewServiceNetwork(byte[] arg1,int arg2,int arg3);
    public A addNewServiceNetwork(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewServiceNetwork(String arg1);
    public interface AdditionalNetworksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AdditionalNetworkDefinitionFluent<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<N>> {

            public N and();
            public N endAdditionalNetwork();    }


    public interface ClusterNetworkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkEntryFluent<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<N>> {

            public N and();
            public N endClusterNetwork();    }


    public interface DefaultNetworkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DefaultNetworkDefinitionFluent<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<N>> {

            public N and();
            public N endDefaultNetwork();    }


    public interface KubeProxyConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyConfigFluent<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<N>> {

            public N and();
            public N endKubeProxyConfig();    }


}
