package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePlacementBuilder extends NodePlacementFluentImpl<NodePlacementBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NodePlacement,NodePlacementBuilder> {

    NodePlacementFluent<?> fluent;
    Boolean validationEnabled;

    public NodePlacementBuilder() {
        this(true);
    }

    public NodePlacementBuilder(Boolean validationEnabled) {
        this(new NodePlacement(), validationEnabled);
    }

    public NodePlacementBuilder(NodePlacementFluent<?> fluent) {
        this(fluent, true);
    }

    public NodePlacementBuilder(NodePlacementFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodePlacement(), validationEnabled);
    }

    public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance) {
        this(fluent, instance, true);
    }

    public NodePlacementBuilder(NodePlacementFluent<?> fluent,NodePlacement instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodePlacementBuilder(NodePlacement instance) {
        this(instance,true);
    }

    public NodePlacementBuilder(NodePlacement instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodePlacement build() {
        NodePlacement buildable = new NodePlacement(fluent.getNodeSelector(),fluent.getTolerations());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodePlacementBuilder that = (NodePlacementBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
