package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeStatusBuilder extends NodeStatusFluentImpl<NodeStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NodeStatus,NodeStatusBuilder> {

    NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NodeStatusBuilder() {
        this(true);
    }

    public NodeStatusBuilder(Boolean validationEnabled) {
        this(new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance) {
        this(fluent, instance, true);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent,NodeStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrentRevision(instance.getCurrentRevision()); 
        fluent.withLastFailedRevision(instance.getLastFailedRevision()); 
        fluent.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors()); 
        fluent.withNodeName(instance.getNodeName()); 
        fluent.withTargetRevision(instance.getTargetRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this(instance,true);
    }

    public NodeStatusBuilder(NodeStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrentRevision(instance.getCurrentRevision()); 
        this.withLastFailedRevision(instance.getLastFailedRevision()); 
        this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors()); 
        this.withNodeName(instance.getNodeName()); 
        this.withTargetRevision(instance.getTargetRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(fluent.getCurrentRevision(),fluent.getLastFailedRevision(),fluent.getLastFailedRevisionErrors(),fluent.getNodeName(),fluent.getTargetRevision());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeStatusBuilder that = (NodeStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
