package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthAPIServerStatusBuilder extends OAuthAPIServerStatusFluentImpl<OAuthAPIServerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<OAuthAPIServerStatus,OAuthAPIServerStatusBuilder> {

    OAuthAPIServerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthAPIServerStatusBuilder() {
        this(true);
    }

    public OAuthAPIServerStatusBuilder(Boolean validationEnabled) {
        this(new OAuthAPIServerStatus(), validationEnabled);
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OAuthAPIServerStatus(), validationEnabled);
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,OAuthAPIServerStatus instance) {
        this(fluent, instance, true);
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatusFluent<?> fluent,OAuthAPIServerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatus instance) {
        this(instance,true);
    }

    public OAuthAPIServerStatusBuilder(OAuthAPIServerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        this.validationEnabled = validationEnabled; 
    }

    public OAuthAPIServerStatus build() {
        OAuthAPIServerStatus buildable = new OAuthAPIServerStatus(fluent.getLatestAvailableRevision());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OAuthAPIServerStatusBuilder that = (OAuthAPIServerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
