package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftControllerManagerSpecBuilder extends OpenShiftControllerManagerSpecFluentImpl<OpenShiftControllerManagerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<OpenShiftControllerManagerSpec,OpenShiftControllerManagerSpecBuilder> {

    OpenShiftControllerManagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftControllerManagerSpecBuilder() {
        this(true);
    }

    public OpenShiftControllerManagerSpecBuilder(Boolean validationEnabled) {
        this(new OpenShiftControllerManagerSpec(), validationEnabled);
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenShiftControllerManagerSpec(), validationEnabled);
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,OpenShiftControllerManagerSpec instance) {
        this(fluent, instance, true);
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpecFluent<?> fluent,OpenShiftControllerManagerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpec instance) {
        this(instance,true);
    }

    public OpenShiftControllerManagerSpecBuilder(OpenShiftControllerManagerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftControllerManagerSpec build() {
        OpenShiftControllerManagerSpec buildable = new OpenShiftControllerManagerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftControllerManagerSpecBuilder that = (OpenShiftControllerManagerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
