package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class StaticIPAMConfigFluentImpl<A extends StaticIPAMConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StaticIPAMConfigFluent<A> {

    private List<StaticIPAMAddressesBuilder> addresses =  new ArrayList<StaticIPAMAddressesBuilder>();
    private StaticIPAMDNSBuilder dns;
    private List<StaticIPAMRoutesBuilder> routes =  new ArrayList<StaticIPAMRoutesBuilder>();

    public StaticIPAMConfigFluentImpl() {
    }

    public StaticIPAMConfigFluentImpl(StaticIPAMConfig instance) {
        this.withAddresses(instance.getAddresses()); 
        this.withDns(instance.getDns()); 
        this.withRoutes(instance.getRoutes()); 
    }

    public A addToAddresses(int index,StaticIPAMAddresses item) {
        if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
    }

    public A setToAddresses(int index,StaticIPAMAddresses item) {
        if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
        StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);
        if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
        if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
         return (A)this;
    }

    public A addToAddresses(StaticIPAMAddresses... items) {
        if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
        for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A addAllToAddresses(Collection<StaticIPAMAddresses> items) {
        if (this.addresses == null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>();}
        for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(StaticIPAMAddresses... items) {
        for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<StaticIPAMAddresses> items) {
        for (StaticIPAMAddresses item : items) {StaticIPAMAddressesBuilder builder = new StaticIPAMAddressesBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<StaticIPAMAddressesBuilder> predicate) {
        if (addresses == null) return (A) this;
        final Iterator<StaticIPAMAddressesBuilder> each = addresses.iterator();
        final List visitables = _visitables.get("addresses");
        while (each.hasNext()) {
          StaticIPAMAddressesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<StaticIPAMAddresses> getAddresses() {
        return build(addresses);
    }

    public List<StaticIPAMAddresses> buildAddresses() {
        return build(addresses);
    }

    public StaticIPAMAddresses buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public StaticIPAMAddresses buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public StaticIPAMAddresses buildLastAddress() {
        return this.addresses.get(addresses.size() - 1).build();
    }

    public StaticIPAMAddresses buildMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        for (StaticIPAMAddressesBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAddresses(List<StaticIPAMAddresses> addresses) {
        if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
        if (addresses != null) {this.addresses = new ArrayList<StaticIPAMAddressesBuilder>(); for (StaticIPAMAddresses item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(StaticIPAMAddresses... addresses) {
        if (this.addresses != null) {this.addresses.clear();}
        if (addresses != null) {for (StaticIPAMAddresses item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses() {
        return addresses != null && !addresses.isEmpty();
    }

    public A addNewAddress(String address,String gateway) {
        return (A)addToAddresses(new StaticIPAMAddresses(address, gateway));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> addNewAddressLike(StaticIPAMAddresses item) {
        return new AddressesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> setNewAddressLike(int index,StaticIPAMAddresses item) {
        return new AddressesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editAddress(int index) {
        if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        return setNewAddressLike(index, buildAddress(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editFirstAddress() {
        if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
        return setNewAddressLike(0, buildAddress(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editLastAddress() {
        int index = addresses.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
        return setNewAddressLike(index, buildAddress(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<A> editMatchingAddress(Predicate<StaticIPAMAddressesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<addresses.size();i++) { 
        if (predicate.test(addresses.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
        return setNewAddressLike(index, buildAddress(index));
    }

    
/**
 * This method has been deprecated, please use method buildDns instead.
 * @return The buildable object.
 */
@Deprecated public StaticIPAMDNS getDns() {
        return this.dns!=null?this.dns.build():null;
    }

    public StaticIPAMDNS buildDns() {
        return this.dns!=null?this.dns.build():null;
    }

    public A withDns(StaticIPAMDNS dns) {
        _visitables.get("dns").remove(this.dns);
        if (dns!=null){ this.dns= new StaticIPAMDNSBuilder(dns); _visitables.get("dns").add(this.dns);} return (A) this;
    }

    public Boolean hasDns() {
        return this.dns != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> withNewDns() {
        return new DnsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> withNewDnsLike(StaticIPAMDNS item) {
        return new DnsNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editDns() {
        return withNewDnsLike(getDns());
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editOrNewDns() {
        return withNewDnsLike(getDns() != null ? getDns(): new StaticIPAMDNSBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<A> editOrNewDnsLike(StaticIPAMDNS item) {
        return withNewDnsLike(getDns() != null ? getDns(): item);
    }

    public A addToRoutes(int index,StaticIPAMRoutes item) {
        if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(index >= 0 ? index : _visitables.get("routes").size(), builder);this.routes.add(index >= 0 ? index : routes.size(), builder); return (A)this;
    }

    public A setToRoutes(int index,StaticIPAMRoutes item) {
        if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
        StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);
        if (index < 0 || index >= _visitables.get("routes").size()) { _visitables.get("routes").add(builder); } else { _visitables.get("routes").set(index, builder);}
        if (index < 0 || index >= routes.size()) { routes.add(builder); } else { routes.set(index, builder);}
         return (A)this;
    }

    public A addToRoutes(StaticIPAMRoutes... items) {
        if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
        for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
    }

    public A addAllToRoutes(Collection<StaticIPAMRoutes> items) {
        if (this.routes == null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>();}
        for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
    }

    public A removeFromRoutes(StaticIPAMRoutes... items) {
        for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoutes(Collection<StaticIPAMRoutes> items) {
        for (StaticIPAMRoutes item : items) {StaticIPAMRoutesBuilder builder = new StaticIPAMRoutesBuilder(item);_visitables.get("routes").remove(builder);if (this.routes != null) {this.routes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoutes(Predicate<StaticIPAMRoutesBuilder> predicate) {
        if (routes == null) return (A) this;
        final Iterator<StaticIPAMRoutesBuilder> each = routes.iterator();
        final List visitables = _visitables.get("routes");
        while (each.hasNext()) {
          StaticIPAMRoutesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoutes instead.
 * @return The buildable object.
 */
@Deprecated public List<StaticIPAMRoutes> getRoutes() {
        return build(routes);
    }

    public List<StaticIPAMRoutes> buildRoutes() {
        return build(routes);
    }

    public StaticIPAMRoutes buildRoute(int index) {
        return this.routes.get(index).build();
    }

    public StaticIPAMRoutes buildFirstRoute() {
        return this.routes.get(0).build();
    }

    public StaticIPAMRoutes buildLastRoute() {
        return this.routes.get(routes.size() - 1).build();
    }

    public StaticIPAMRoutes buildMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        for (StaticIPAMRoutesBuilder item: routes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRoutes(List<StaticIPAMRoutes> routes) {
        if (this.routes != null) { _visitables.get("routes").removeAll(this.routes);}
        if (routes != null) {this.routes = new ArrayList<StaticIPAMRoutesBuilder>(); for (StaticIPAMRoutes item : routes){this.addToRoutes(item);}} else { this.routes = null;} return (A) this;
    }

    public A withRoutes(StaticIPAMRoutes... routes) {
        if (this.routes != null) {this.routes.clear();}
        if (routes != null) {for (StaticIPAMRoutes item :routes){ this.addToRoutes(item);}} return (A) this;
    }

    public Boolean hasRoutes() {
        return routes != null && !routes.isEmpty();
    }

    public A addNewRoute(String destination,String gateway) {
        return (A)addToRoutes(new StaticIPAMRoutes(destination, gateway));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> addNewRoute() {
        return new RoutesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> addNewRouteLike(StaticIPAMRoutes item) {
        return new RoutesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> setNewRouteLike(int index,StaticIPAMRoutes item) {
        return new RoutesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editRoute(int index) {
        if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
        return setNewRouteLike(index, buildRoute(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editFirstRoute() {
        if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
        return setNewRouteLike(0, buildRoute(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editLastRoute() {
        int index = routes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
        return setNewRouteLike(index, buildRoute(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<A> editMatchingRoute(Predicate<StaticIPAMRoutesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<routes.size();i++) { 
        if (predicate.test(routes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
        return setNewRouteLike(index, buildRoute(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StaticIPAMConfigFluentImpl that = (StaticIPAMConfigFluentImpl) o;
        if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
        if (dns != null ? !dns.equals(that.dns) :that.dns != null) return false;
        if (routes != null ? !routes.equals(that.routes) :that.routes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(addresses,  dns,  routes,  super.hashCode());
    }

    public class AddressesNestedImpl<N> extends StaticIPAMAddressesFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StaticIPAMAddressesBuilder builder;
        private final int index;

            AddressesNestedImpl(int index,StaticIPAMAddresses item) {
                this.index = index;
                this.builder = new StaticIPAMAddressesBuilder(this, item);
                        
            }

            AddressesNestedImpl() {
                this.index = -1;
                this.builder = new StaticIPAMAddressesBuilder(this);
                        
            }

            public N and() {
                return (N) StaticIPAMConfigFluentImpl.this.setToAddresses(index,builder.build());
            }

            public N endAddress() {
                return and();
            }
    }


    public class DnsNestedImpl<N> extends StaticIPAMDNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.DnsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StaticIPAMDNSBuilder builder;

            DnsNestedImpl(StaticIPAMDNS item) {
                this.builder = new StaticIPAMDNSBuilder(this, item);
                        
            }

            DnsNestedImpl() {
                this.builder = new StaticIPAMDNSBuilder(this);
                        
            }

            public N and() {
                return (N) StaticIPAMConfigFluentImpl.this.withDns(builder.build());
            }

            public N endDns() {
                return and();
            }
    }


    public class RoutesNestedImpl<N> extends StaticIPAMRoutesFluentImpl<io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.StaticIPAMConfigFluent.RoutesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StaticIPAMRoutesBuilder builder;
        private final int index;

            RoutesNestedImpl(int index,StaticIPAMRoutes item) {
                this.index = index;
                this.builder = new StaticIPAMRoutesBuilder(this, item);
                        
            }

            RoutesNestedImpl() {
                this.index = -1;
                this.builder = new StaticIPAMRoutesBuilder(this);
                        
            }

            public N and() {
                return (N) StaticIPAMConfigFluentImpl.this.setToRoutes(index,builder.build());
            }

            public N endRoute() {
                return and();
            }
    }


}
