package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StaticIPAMRoutesBuilder extends StaticIPAMRoutesFluentImpl<StaticIPAMRoutesBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<StaticIPAMRoutes,StaticIPAMRoutesBuilder> {

    StaticIPAMRoutesFluent<?> fluent;
    Boolean validationEnabled;

    public StaticIPAMRoutesBuilder() {
        this(true);
    }

    public StaticIPAMRoutesBuilder(Boolean validationEnabled) {
        this(new StaticIPAMRoutes(), validationEnabled);
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent) {
        this(fluent, true);
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StaticIPAMRoutes(), validationEnabled);
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,StaticIPAMRoutes instance) {
        this(fluent, instance, true);
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,StaticIPAMRoutes instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDestination(instance.getDestination()); 
        fluent.withGateway(instance.getGateway()); 
        this.validationEnabled = validationEnabled; 
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutes instance) {
        this(instance,true);
    }

    public StaticIPAMRoutesBuilder(StaticIPAMRoutes instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDestination(instance.getDestination()); 
        this.withGateway(instance.getGateway()); 
        this.validationEnabled = validationEnabled; 
    }

    public StaticIPAMRoutes build() {
        StaticIPAMRoutes buildable = new StaticIPAMRoutes(fluent.getDestination(),fluent.getGateway());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StaticIPAMRoutesBuilder that = (StaticIPAMRoutesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
