package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ImageContentSourcePolicySpecFluentImpl<A extends ImageContentSourcePolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImageContentSourcePolicySpecFluent<A> {

    private List<RepositoryDigestMirrorsBuilder> repositoryDigestMirrors =  new ArrayList<RepositoryDigestMirrorsBuilder>();

    public ImageContentSourcePolicySpecFluentImpl() {
    }

    public ImageContentSourcePolicySpecFluentImpl(ImageContentSourcePolicySpec instance) {
        this.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors()); 
    }

    public A addToRepositoryDigestMirrors(int index,RepositoryDigestMirrors item) {
        if (this.repositoryDigestMirrors == null) {this.repositoryDigestMirrors = new ArrayList<RepositoryDigestMirrorsBuilder>();}
        RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);_visitables.get("repositoryDigestMirrors").add(index >= 0 ? index : _visitables.get("repositoryDigestMirrors").size(), builder);this.repositoryDigestMirrors.add(index >= 0 ? index : repositoryDigestMirrors.size(), builder); return (A)this;
    }

    public A setToRepositoryDigestMirrors(int index,RepositoryDigestMirrors item) {
        if (this.repositoryDigestMirrors == null) {this.repositoryDigestMirrors = new ArrayList<RepositoryDigestMirrorsBuilder>();}
        RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);
        if (index < 0 || index >= _visitables.get("repositoryDigestMirrors").size()) { _visitables.get("repositoryDigestMirrors").add(builder); } else { _visitables.get("repositoryDigestMirrors").set(index, builder);}
        if (index < 0 || index >= repositoryDigestMirrors.size()) { repositoryDigestMirrors.add(builder); } else { repositoryDigestMirrors.set(index, builder);}
         return (A)this;
    }

    public A addToRepositoryDigestMirrors(RepositoryDigestMirrors... items) {
        if (this.repositoryDigestMirrors == null) {this.repositoryDigestMirrors = new ArrayList<RepositoryDigestMirrorsBuilder>();}
        for (RepositoryDigestMirrors item : items) {RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);_visitables.get("repositoryDigestMirrors").add(builder);this.repositoryDigestMirrors.add(builder);} return (A)this;
    }

    public A addAllToRepositoryDigestMirrors(Collection<RepositoryDigestMirrors> items) {
        if (this.repositoryDigestMirrors == null) {this.repositoryDigestMirrors = new ArrayList<RepositoryDigestMirrorsBuilder>();}
        for (RepositoryDigestMirrors item : items) {RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);_visitables.get("repositoryDigestMirrors").add(builder);this.repositoryDigestMirrors.add(builder);} return (A)this;
    }

    public A removeFromRepositoryDigestMirrors(RepositoryDigestMirrors... items) {
        for (RepositoryDigestMirrors item : items) {RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);_visitables.get("repositoryDigestMirrors").remove(builder);if (this.repositoryDigestMirrors != null) {this.repositoryDigestMirrors.remove(builder);}} return (A)this;
    }

    public A removeAllFromRepositoryDigestMirrors(Collection<RepositoryDigestMirrors> items) {
        for (RepositoryDigestMirrors item : items) {RepositoryDigestMirrorsBuilder builder = new RepositoryDigestMirrorsBuilder(item);_visitables.get("repositoryDigestMirrors").remove(builder);if (this.repositoryDigestMirrors != null) {this.repositoryDigestMirrors.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRepositoryDigestMirrors(Predicate<RepositoryDigestMirrorsBuilder> predicate) {
        if (repositoryDigestMirrors == null) return (A) this;
        final Iterator<RepositoryDigestMirrorsBuilder> each = repositoryDigestMirrors.iterator();
        final List visitables = _visitables.get("repositoryDigestMirrors");
        while (each.hasNext()) {
          RepositoryDigestMirrorsBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRepositoryDigestMirrors instead.
 * @return The buildable object.
 */
@Deprecated public List<RepositoryDigestMirrors> getRepositoryDigestMirrors() {
        return build(repositoryDigestMirrors);
    }

    public List<RepositoryDigestMirrors> buildRepositoryDigestMirrors() {
        return build(repositoryDigestMirrors);
    }

    public RepositoryDigestMirrors buildRepositoryDigestMirror(int index) {
        return this.repositoryDigestMirrors.get(index).build();
    }

    public RepositoryDigestMirrors buildFirstRepositoryDigestMirror() {
        return this.repositoryDigestMirrors.get(0).build();
    }

    public RepositoryDigestMirrors buildLastRepositoryDigestMirror() {
        return this.repositoryDigestMirrors.get(repositoryDigestMirrors.size() - 1).build();
    }

    public RepositoryDigestMirrors buildMatchingRepositoryDigestMirror(Predicate<RepositoryDigestMirrorsBuilder> predicate) {
        for (RepositoryDigestMirrorsBuilder item: repositoryDigestMirrors) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRepositoryDigestMirror(Predicate<RepositoryDigestMirrorsBuilder> predicate) {
        for (RepositoryDigestMirrorsBuilder item: repositoryDigestMirrors) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRepositoryDigestMirrors(List<RepositoryDigestMirrors> repositoryDigestMirrors) {
        if (this.repositoryDigestMirrors != null) { _visitables.get("repositoryDigestMirrors").removeAll(this.repositoryDigestMirrors);}
        if (repositoryDigestMirrors != null) {this.repositoryDigestMirrors = new ArrayList<RepositoryDigestMirrorsBuilder>(); for (RepositoryDigestMirrors item : repositoryDigestMirrors){this.addToRepositoryDigestMirrors(item);}} else { this.repositoryDigestMirrors = null;} return (A) this;
    }

    public A withRepositoryDigestMirrors(RepositoryDigestMirrors... repositoryDigestMirrors) {
        if (this.repositoryDigestMirrors != null) {this.repositoryDigestMirrors.clear();}
        if (repositoryDigestMirrors != null) {for (RepositoryDigestMirrors item :repositoryDigestMirrors){ this.addToRepositoryDigestMirrors(item);}} return (A) this;
    }

    public Boolean hasRepositoryDigestMirrors() {
        return repositoryDigestMirrors != null && !repositoryDigestMirrors.isEmpty();
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> addNewRepositoryDigestMirror() {
        return new RepositoryDigestMirrorsNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> addNewRepositoryDigestMirrorLike(RepositoryDigestMirrors item) {
        return new RepositoryDigestMirrorsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> setNewRepositoryDigestMirrorLike(int index,RepositoryDigestMirrors item) {
        return new RepositoryDigestMirrorsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> editRepositoryDigestMirror(int index) {
        if (repositoryDigestMirrors.size() <= index) throw new RuntimeException("Can't edit repositoryDigestMirrors. Index exceeds size.");
        return setNewRepositoryDigestMirrorLike(index, buildRepositoryDigestMirror(index));
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> editFirstRepositoryDigestMirror() {
        if (repositoryDigestMirrors.size() == 0) throw new RuntimeException("Can't edit first repositoryDigestMirrors. The list is empty.");
        return setNewRepositoryDigestMirrorLike(0, buildRepositoryDigestMirror(0));
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> editLastRepositoryDigestMirror() {
        int index = repositoryDigestMirrors.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last repositoryDigestMirrors. The list is empty.");
        return setNewRepositoryDigestMirrorLike(index, buildRepositoryDigestMirror(index));
    }

    public io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<A> editMatchingRepositoryDigestMirror(Predicate<RepositoryDigestMirrorsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<repositoryDigestMirrors.size();i++) { 
        if (predicate.test(repositoryDigestMirrors.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching repositoryDigestMirrors. No match found.");
        return setNewRepositoryDigestMirrorLike(index, buildRepositoryDigestMirror(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImageContentSourcePolicySpecFluentImpl that = (ImageContentSourcePolicySpecFluentImpl) o;
        if (repositoryDigestMirrors != null ? !repositoryDigestMirrors.equals(that.repositoryDigestMirrors) :that.repositoryDigestMirrors != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(repositoryDigestMirrors,  super.hashCode());
    }

    public class RepositoryDigestMirrorsNestedImpl<N> extends RepositoryDigestMirrorsFluentImpl<io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<N>> implements io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent.RepositoryDigestMirrorsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RepositoryDigestMirrorsBuilder builder;
        private final int index;

            RepositoryDigestMirrorsNestedImpl(int index,RepositoryDigestMirrors item) {
                this.index = index;
                this.builder = new RepositoryDigestMirrorsBuilder(this, item);
                        
            }

            RepositoryDigestMirrorsNestedImpl() {
                this.index = -1;
                this.builder = new RepositoryDigestMirrorsBuilder(this);
                        
            }

            public N and() {
                return (N) ImageContentSourcePolicySpecFluentImpl.this.setToRepositoryDigestMirrors(index,builder.build());
            }

            public N endRepositoryDigestMirror() {
                return and();
            }
    }


}
