package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class DNSZoneFluentImpl<A extends DNSZoneFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSZoneFluent<A> {

    private String id;
    private java.util.Map<String,String> tags;

    public DNSZoneFluentImpl() {
    }

    public DNSZoneFluentImpl(DNSZone instance) {
        this.withId(instance.getId()); 
        this.withTags(instance.getTags()); 
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id=id; return (A) this;
    }

    public Boolean hasId() {
        return this.id != null;
    }

    public A withNewId(StringBuilder arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(int[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(char[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(StringBuffer arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(byte[] arg1,int arg2) {
        return (A)withId(new String(arg1, arg2));
    }

    public A withNewId(byte[] arg1) {
        return (A)withId(new String(arg1));
    }

    public A withNewId(char[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3) {
        return (A)withId(new String(arg1, arg2, arg3));
    }

    public A withNewId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewId(String arg1) {
        return (A)withId(new String(arg1));
    }

    public A addToTags(String key,String value) {
        if(this.tags == null && key != null && value != null) { this.tags = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.tags.put(key, value);} return (A)this;
    }

    public A addToTags(java.util.Map<String,String> map) {
        if(this.tags == null && map != null) { this.tags = new LinkedHashMap<String,String>(); }
        if(map != null) { this.tags.putAll(map);} return (A)this;
    }

    public A removeFromTags(String key) {
        if(this.tags == null) { return (A) this; }
        if(key != null && this.tags != null) {this.tags.remove(key);} return (A)this;
    }

    public A removeFromTags(java.util.Map<String,String> map) {
        if(this.tags == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.tags != null){this.tags.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getTags() {
        return this.tags;
    }

    public <K extends Object,V extends Object>A withTags(java.util.Map<String,String> tags) {
        if (tags == null) { this.tags =  null;} else {this.tags = new LinkedHashMap<String,String>(tags);} return (A) this;
    }

    public Boolean hasTags() {
        return this.tags != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DNSZoneFluentImpl that = (DNSZoneFluentImpl) o;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(id,  tags,  super.hashCode());
    }

}
