package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSClassicLoadBalancerParametersBuilder extends AWSClassicLoadBalancerParametersFluentImpl<AWSClassicLoadBalancerParametersBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<AWSClassicLoadBalancerParameters,AWSClassicLoadBalancerParametersBuilder> {

    AWSClassicLoadBalancerParametersFluent<?> fluent;
    Boolean validationEnabled;

    public AWSClassicLoadBalancerParametersBuilder() {
        this(true);
    }

    public AWSClassicLoadBalancerParametersBuilder(Boolean validationEnabled) {
        this(new AWSClassicLoadBalancerParameters(), validationEnabled);
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent) {
        this(fluent, true);
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AWSClassicLoadBalancerParameters(), validationEnabled);
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,AWSClassicLoadBalancerParameters instance) {
        this(fluent, instance, true);
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParametersFluent<?> fluent,AWSClassicLoadBalancerParameters instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParameters instance) {
        this(instance,true);
    }

    public AWSClassicLoadBalancerParametersBuilder(AWSClassicLoadBalancerParameters instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public AWSClassicLoadBalancerParameters build() {
        AWSClassicLoadBalancerParameters buildable = new AWSClassicLoadBalancerParameters();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AWSClassicLoadBalancerParametersBuilder that = (AWSClassicLoadBalancerParametersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
