package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AWSLoadBalancerParametersBuilder extends AWSLoadBalancerParametersFluentImpl<AWSLoadBalancerParametersBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<AWSLoadBalancerParameters,AWSLoadBalancerParametersBuilder> {

    AWSLoadBalancerParametersFluent<?> fluent;
    Boolean validationEnabled;

    public AWSLoadBalancerParametersBuilder() {
        this(true);
    }

    public AWSLoadBalancerParametersBuilder(Boolean validationEnabled) {
        this(new AWSLoadBalancerParameters(), validationEnabled);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent) {
        this(fluent, true);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AWSLoadBalancerParameters(), validationEnabled);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,AWSLoadBalancerParameters instance) {
        this(fluent, instance, true);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,AWSLoadBalancerParameters instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClassicLoadBalancer(instance.getClassicLoadBalancer()); 
        fluent.withNetworkLoadBalancer(instance.getNetworkLoadBalancer()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance) {
        this(instance,true);
    }

    public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withClassicLoadBalancer(instance.getClassicLoadBalancer()); 
        this.withNetworkLoadBalancer(instance.getNetworkLoadBalancer()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public AWSLoadBalancerParameters build() {
        AWSLoadBalancerParameters buildable = new AWSLoadBalancerParameters(fluent.getClassicLoadBalancer(),fluent.getNetworkLoadBalancer(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AWSLoadBalancerParametersBuilder that = (AWSLoadBalancerParametersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
