package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSISnapshotControllerStatusBuilder extends CSISnapshotControllerStatusFluentImpl<CSISnapshotControllerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CSISnapshotControllerStatus,CSISnapshotControllerStatusBuilder> {

    CSISnapshotControllerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public CSISnapshotControllerStatusBuilder() {
        this(true);
    }

    public CSISnapshotControllerStatusBuilder(Boolean validationEnabled) {
        this(new CSISnapshotControllerStatus(), validationEnabled);
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSISnapshotControllerStatus(), validationEnabled);
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,CSISnapshotControllerStatus instance) {
        this(fluent, instance, true);
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatusFluent<?> fluent,CSISnapshotControllerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatus instance) {
        this(instance,true);
    }

    public CSISnapshotControllerStatusBuilder(CSISnapshotControllerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSISnapshotControllerStatus build() {
        CSISnapshotControllerStatus buildable = new CSISnapshotControllerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSISnapshotControllerStatusBuilder that = (CSISnapshotControllerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
