package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleBuilder extends ConsoleFluentImpl<ConsoleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Console,ConsoleBuilder> {

    ConsoleFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleBuilder() {
        this(true);
    }

    public ConsoleBuilder(Boolean validationEnabled) {
        this(new Console(), validationEnabled);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Console(), validationEnabled);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent,Console instance) {
        this(fluent, instance, true);
    }

    public ConsoleBuilder(ConsoleFluent<?> fluent,Console instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleBuilder(Console instance) {
        this(instance,true);
    }

    public ConsoleBuilder(Console instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public Console build() {
        Console buildable = new Console(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleBuilder that = (ConsoleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
