package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSStatusBuilder extends DNSStatusFluentImpl<DNSStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<DNSStatus,DNSStatusBuilder> {

    DNSStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DNSStatusBuilder() {
        this(true);
    }

    public DNSStatusBuilder(Boolean validationEnabled) {
        this(new DNSStatus(), validationEnabled);
    }

    public DNSStatusBuilder(DNSStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSStatusBuilder(DNSStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSStatus(), validationEnabled);
    }

    public DNSStatusBuilder(DNSStatusFluent<?> fluent,DNSStatus instance) {
        this(fluent, instance, true);
    }

    public DNSStatusBuilder(DNSStatusFluent<?> fluent,DNSStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClusterDomain(instance.getClusterDomain()); 
        fluent.withClusterIP(instance.getClusterIP()); 
        fluent.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSStatusBuilder(DNSStatus instance) {
        this(instance,true);
    }

    public DNSStatusBuilder(DNSStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withClusterDomain(instance.getClusterDomain()); 
        this.withClusterIP(instance.getClusterIP()); 
        this.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSStatus build() {
        DNSStatus buildable = new DNSStatus(fluent.getClusterDomain(),fluent.getClusterIP(),fluent.getConditions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSStatusBuilder that = (DNSStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
