package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class EndpointPublishingStrategyFluentImpl<A extends EndpointPublishingStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointPublishingStrategyFluent<A> {

    private HostNetworkStrategyBuilder hostNetwork;
    private LoadBalancerStrategyBuilder loadBalancer;
    private NodePortStrategyBuilder nodePort;
    private PrivateStrategyBuilder _private;
    private String type;

    public EndpointPublishingStrategyFluentImpl() {
    }

    public EndpointPublishingStrategyFluentImpl(EndpointPublishingStrategy instance) {
        this.withHostNetwork(instance.getHostNetwork()); 
        this.withLoadBalancer(instance.getLoadBalancer()); 
        this.withNodePort(instance.getNodePort()); 
        this.withPrivate(instance.getPrivate()); 
        this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildHostNetwork instead.
 * @return The buildable object.
 */
@Deprecated public HostNetworkStrategy getHostNetwork() {
        return this.hostNetwork!=null?this.hostNetwork.build():null;
    }

    public HostNetworkStrategy buildHostNetwork() {
        return this.hostNetwork!=null?this.hostNetwork.build():null;
    }

    public A withHostNetwork(HostNetworkStrategy hostNetwork) {
        _visitables.get("hostNetwork").remove(this.hostNetwork);
        if (hostNetwork!=null){ this.hostNetwork= new HostNetworkStrategyBuilder(hostNetwork); _visitables.get("hostNetwork").add(this.hostNetwork);} return (A) this;
    }

    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<A> withNewHostNetwork() {
        return new HostNetworkNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<A> withNewHostNetworkLike(HostNetworkStrategy item) {
        return new HostNetworkNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<A> editHostNetwork() {
        return withNewHostNetworkLike(getHostNetwork());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<A> editOrNewHostNetwork() {
        return withNewHostNetworkLike(getHostNetwork() != null ? getHostNetwork(): new HostNetworkStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<A> editOrNewHostNetworkLike(HostNetworkStrategy item) {
        return withNewHostNetworkLike(getHostNetwork() != null ? getHostNetwork(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerStrategy getLoadBalancer() {
        return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public LoadBalancerStrategy buildLoadBalancer() {
        return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(LoadBalancerStrategy loadBalancer) {
        _visitables.get("loadBalancer").remove(this.loadBalancer);
        if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStrategyBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerStrategy item) {
        return new LoadBalancerNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<A> editLoadBalancer() {
        return withNewLoadBalancerLike(getLoadBalancer());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
        return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerStrategy item) {
        return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNodePort instead.
 * @return The buildable object.
 */
@Deprecated public NodePortStrategy getNodePort() {
        return this.nodePort!=null?this.nodePort.build():null;
    }

    public NodePortStrategy buildNodePort() {
        return this.nodePort!=null?this.nodePort.build():null;
    }

    public A withNodePort(NodePortStrategy nodePort) {
        _visitables.get("nodePort").remove(this.nodePort);
        if (nodePort!=null){ this.nodePort= new NodePortStrategyBuilder(nodePort); _visitables.get("nodePort").add(this.nodePort);} return (A) this;
    }

    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<A> withNewNodePort() {
        return new NodePortNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<A> withNewNodePortLike(NodePortStrategy item) {
        return new NodePortNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<A> editNodePort() {
        return withNewNodePortLike(getNodePort());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<A> editOrNewNodePort() {
        return withNewNodePortLike(getNodePort() != null ? getNodePort(): new NodePortStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<A> editOrNewNodePortLike(NodePortStrategy item) {
        return withNewNodePortLike(getNodePort() != null ? getNodePort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPrivate instead.
 * @return The buildable object.
 */
@Deprecated public PrivateStrategy getPrivate() {
        return this._private!=null?this._private.build():null;
    }

    public PrivateStrategy buildPrivate() {
        return this._private!=null?this._private.build():null;
    }

    public A withPrivate(PrivateStrategy _private) {
        _visitables.get("_private").remove(this._private);
        if (_private!=null){ this._private= new PrivateStrategyBuilder(_private); _visitables.get("_private").add(this._private);} return (A) this;
    }

    public Boolean hasPrivate() {
        return this._private != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<A> withNewPrivate() {
        return new PrivateNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<A> withNewPrivateLike(PrivateStrategy item) {
        return new PrivateNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<A> editPrivate() {
        return withNewPrivateLike(getPrivate());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<A> editOrNewPrivate() {
        return withNewPrivateLike(getPrivate() != null ? getPrivate(): new PrivateStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<A> editOrNewPrivateLike(PrivateStrategy item) {
        return withNewPrivateLike(getPrivate() != null ? getPrivate(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointPublishingStrategyFluentImpl that = (EndpointPublishingStrategyFluentImpl) o;
        if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
        if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
        if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
        if (_private != null ? !_private.equals(that._private) :that._private != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostNetwork,  loadBalancer,  nodePort,  _private,  type,  super.hashCode());
    }

    public class HostNetworkNestedImpl<N> extends HostNetworkStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.HostNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HostNetworkStrategyBuilder builder;

            HostNetworkNestedImpl(HostNetworkStrategy item) {
                this.builder = new HostNetworkStrategyBuilder(this, item);
                        
            }

            HostNetworkNestedImpl() {
                this.builder = new HostNetworkStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointPublishingStrategyFluentImpl.this.withHostNetwork(builder.build());
            }

            public N endHostNetwork() {
                return and();
            }
    }


    public class LoadBalancerNestedImpl<N> extends LoadBalancerStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<N>> implements io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoadBalancerStrategyBuilder builder;

            LoadBalancerNestedImpl(LoadBalancerStrategy item) {
                this.builder = new LoadBalancerStrategyBuilder(this, item);
                        
            }

            LoadBalancerNestedImpl() {
                this.builder = new LoadBalancerStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointPublishingStrategyFluentImpl.this.withLoadBalancer(builder.build());
            }

            public N endLoadBalancer() {
                return and();
            }
    }


    public class NodePortNestedImpl<N> extends NodePortStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<N>> implements io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.NodePortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodePortStrategyBuilder builder;

            NodePortNestedImpl(NodePortStrategy item) {
                this.builder = new NodePortStrategyBuilder(this, item);
                        
            }

            NodePortNestedImpl() {
                this.builder = new NodePortStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointPublishingStrategyFluentImpl.this.withNodePort(builder.build());
            }

            public N endNodePort() {
                return and();
            }
    }


    public class PrivateNestedImpl<N> extends PrivateStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<N>> implements io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent.PrivateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PrivateStrategyBuilder builder;

            PrivateNestedImpl(PrivateStrategy item) {
                this.builder = new PrivateStrategyBuilder(this, item);
                        
            }

            PrivateNestedImpl() {
                this.builder = new PrivateStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointPublishingStrategyFluentImpl.this.withPrivate(builder.build());
            }

            public N endPrivate() {
                return and();
            }
    }


}
