package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EtcdListBuilder extends EtcdListFluentImpl<EtcdListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<EtcdList,EtcdListBuilder> {

    EtcdListFluent<?> fluent;
    Boolean validationEnabled;

    public EtcdListBuilder() {
        this(true);
    }

    public EtcdListBuilder(Boolean validationEnabled) {
        this(new EtcdList(), validationEnabled);
    }

    public EtcdListBuilder(EtcdListFluent<?> fluent) {
        this(fluent, true);
    }

    public EtcdListBuilder(EtcdListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EtcdList(), validationEnabled);
    }

    public EtcdListBuilder(EtcdListFluent<?> fluent,EtcdList instance) {
        this(fluent, instance, true);
    }

    public EtcdListBuilder(EtcdListFluent<?> fluent,EtcdList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdListBuilder(EtcdList instance) {
        this(instance,true);
    }

    public EtcdListBuilder(EtcdList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdList build() {
        EtcdList buildable = new EtcdList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EtcdListBuilder that = (EtcdListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
