package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPAMConfigBuilder extends IPAMConfigFluentImpl<IPAMConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IPAMConfig,IPAMConfigBuilder> {

    IPAMConfigFluent<?> fluent;
    Boolean validationEnabled;

    public IPAMConfigBuilder() {
        this(true);
    }

    public IPAMConfigBuilder(Boolean validationEnabled) {
        this(new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IPAMConfig(), validationEnabled);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance) {
        this(fluent, instance, true);
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent,IPAMConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IPAMConfigBuilder(IPAMConfig instance) {
        this(instance,true);
    }

    public IPAMConfigBuilder(IPAMConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withStaticIPAMConfig(instance.getStaticIPAMConfig()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public IPAMConfig build() {
        IPAMConfig buildable = new IPAMConfig(fluent.getStaticIPAMConfig(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IPAMConfigBuilder that = (IPAMConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
