package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImagePrunerStatusBuilder extends ImagePrunerStatusFluentImpl<ImagePrunerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ImagePrunerStatus,ImagePrunerStatusBuilder> {

    ImagePrunerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ImagePrunerStatusBuilder() {
        this(true);
    }

    public ImagePrunerStatusBuilder(Boolean validationEnabled) {
        this(new ImagePrunerStatus(), validationEnabled);
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ImagePrunerStatus(), validationEnabled);
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,ImagePrunerStatus instance) {
        this(fluent, instance, true);
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatusFluent<?> fluent,ImagePrunerStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatus instance) {
        this(instance,true);
    }

    public ImagePrunerStatusBuilder(ImagePrunerStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public ImagePrunerStatus build() {
        ImagePrunerStatus buildable = new ImagePrunerStatus(fluent.getConditions(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImagePrunerStatusBuilder that = (ImagePrunerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
