package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerListBuilder extends IngressControllerListFluentImpl<IngressControllerListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IngressControllerList,IngressControllerListBuilder> {

    IngressControllerListFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerListBuilder() {
        this(true);
    }

    public IngressControllerListBuilder(Boolean validationEnabled) {
        this(new IngressControllerList(), validationEnabled);
    }

    public IngressControllerListBuilder(IngressControllerListFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressControllerList(), validationEnabled);
    }

    public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,IngressControllerList instance) {
        this(fluent, instance, true);
    }

    public IngressControllerListBuilder(IngressControllerListFluent<?> fluent,IngressControllerList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerListBuilder(IngressControllerList instance) {
        this(instance,true);
    }

    public IngressControllerListBuilder(IngressControllerList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerList build() {
        IngressControllerList buildable = new IngressControllerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerListBuilder that = (IngressControllerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
