package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeSchedulerBuilder extends KubeSchedulerFluentImpl<KubeSchedulerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KubeScheduler,KubeSchedulerBuilder> {

    KubeSchedulerFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchedulerBuilder() {
        this(true);
    }

    public KubeSchedulerBuilder(Boolean validationEnabled) {
        this(new KubeScheduler(), validationEnabled);
    }

    public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeScheduler(), validationEnabled);
    }

    public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,KubeScheduler instance) {
        this(fluent, instance, true);
    }

    public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,KubeScheduler instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeSchedulerBuilder(KubeScheduler instance) {
        this(instance,true);
    }

    public KubeSchedulerBuilder(KubeScheduler instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeScheduler build() {
        KubeScheduler buildable = new KubeScheduler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeSchedulerBuilder that = (KubeSchedulerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
