package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubeSchedulerStatusFluent<A extends KubeSchedulerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> addNewCondition();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> editCondition(int index);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> editFirstCondition();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> editLastCondition();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate);
    public A addToGenerations(int index,GenerationStatus item);
    public A setToGenerations(int index,GenerationStatus item);
    public A addToGenerations(GenerationStatus... items);
    public A addAllToGenerations(Collection<GenerationStatus> items);
    public A removeFromGenerations(GenerationStatus... items);
    public A removeAllFromGenerations(Collection<GenerationStatus> items);
    public A removeMatchingFromGenerations(Predicate<GenerationStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations();
    public List<GenerationStatus> buildGenerations();
    public GenerationStatus buildGeneration(int index);
    public GenerationStatus buildFirstGeneration();
    public GenerationStatus buildLastGeneration();
    public GenerationStatus buildMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Boolean hasMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public A withGenerations(List<GenerationStatus> generations);
    public A withGenerations(GenerationStatus... generations);
    public Boolean hasGenerations();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> addNewGeneration();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> editGeneration(int index);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> editFirstGeneration();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> editLastGeneration();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<A> editMatchingGeneration(Predicate<GenerationStatusBuilder> predicate);
    public Integer getLatestAvailableRevision();
    public A withLatestAvailableRevision(Integer latestAvailableRevision);
    public Boolean hasLatestAvailableRevision();
    public A withNewLatestAvailableRevision(int arg0);
    public String getLatestAvailableRevisionReason();
    public A withLatestAvailableRevisionReason(String latestAvailableRevisionReason);
    public Boolean hasLatestAvailableRevisionReason();
    public A withNewLatestAvailableRevisionReason(StringBuilder arg1);
    public A withNewLatestAvailableRevisionReason(int[] arg1,int arg2,int arg3);
    public A withNewLatestAvailableRevisionReason(char[] arg1);
    public A withNewLatestAvailableRevisionReason(StringBuffer arg1);
    public A withNewLatestAvailableRevisionReason(byte[] arg1,int arg2);
    public A withNewLatestAvailableRevisionReason(byte[] arg1);
    public A withNewLatestAvailableRevisionReason(char[] arg1,int arg2,int arg3);
    public A withNewLatestAvailableRevisionReason(byte[] arg1,int arg2,int arg3);
    public A withNewLatestAvailableRevisionReason(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLatestAvailableRevisionReason(String arg1);
    public A addToNodeStatuses(int index,NodeStatus item);
    public A setToNodeStatuses(int index,NodeStatus item);
    public A addToNodeStatuses(NodeStatus... items);
    public A addAllToNodeStatuses(Collection<NodeStatus> items);
    public A removeFromNodeStatuses(NodeStatus... items);
    public A removeAllFromNodeStatuses(Collection<NodeStatus> items);
    public A removeMatchingFromNodeStatuses(Predicate<NodeStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNodeStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<NodeStatus> getNodeStatuses();
    public List<NodeStatus> buildNodeStatuses();
    public NodeStatus buildNodeStatus(int index);
    public NodeStatus buildFirstNodeStatus();
    public NodeStatus buildLastNodeStatus();
    public NodeStatus buildMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
    public Boolean hasMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
    public A withNodeStatuses(List<NodeStatus> nodeStatuses);
    public A withNodeStatuses(NodeStatus... nodeStatuses);
    public Boolean hasNodeStatuses();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> addNewNodeStatus();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> addNewNodeStatusLike(NodeStatus item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> setNewNodeStatusLike(int index,NodeStatus item);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> editNodeStatus(int index);
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> editFirstNodeStatus();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> editLastNodeStatus();
    public io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<A> editMatchingNodeStatus(Predicate<NodeStatusBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(long arg1);
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public A withNewReadyReplicas(int arg0);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface GenerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenerationStatusFluent<io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.GenerationsNested<N>> {

            public N and();
            public N endGeneration();    }


    public interface NodeStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeStatusFluent<io.fabric8.openshift.api.model.operator.v1.KubeSchedulerStatusFluent.NodeStatusesNested<N>> {

            public N and();
            public N endNodeStatus();    }


}
