package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeStorageVersionMigratorBuilder extends KubeStorageVersionMigratorFluentImpl<KubeStorageVersionMigratorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KubeStorageVersionMigrator,KubeStorageVersionMigratorBuilder> {

    KubeStorageVersionMigratorFluent<?> fluent;
    Boolean validationEnabled;

    public KubeStorageVersionMigratorBuilder() {
        this(true);
    }

    public KubeStorageVersionMigratorBuilder(Boolean validationEnabled) {
        this(new KubeStorageVersionMigrator(), validationEnabled);
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent) {
        this(fluent, true);
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubeStorageVersionMigrator(), validationEnabled);
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,KubeStorageVersionMigrator instance) {
        this(fluent, instance, true);
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigratorFluent<?> fluent,KubeStorageVersionMigrator instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigrator instance) {
        this(instance,true);
    }

    public KubeStorageVersionMigratorBuilder(KubeStorageVersionMigrator instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubeStorageVersionMigrator build() {
        KubeStorageVersionMigrator buildable = new KubeStorageVersionMigrator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeStorageVersionMigratorBuilder that = (KubeStorageVersionMigratorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
