package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getCurrentRevision();
    public A withCurrentRevision(Integer currentRevision);
    public Boolean hasCurrentRevision();
    public A withNewCurrentRevision(int arg0);
    public Integer getLastFailedRevision();
    public A withLastFailedRevision(Integer lastFailedRevision);
    public Boolean hasLastFailedRevision();
    public A withNewLastFailedRevision(int arg0);
    public A addToLastFailedRevisionErrors(int index,String item);
    public A setToLastFailedRevisionErrors(int index,String item);
    public A addToLastFailedRevisionErrors(String... items);
    public A addAllToLastFailedRevisionErrors(Collection<String> items);
    public A removeFromLastFailedRevisionErrors(String... items);
    public A removeAllFromLastFailedRevisionErrors(Collection<String> items);
    public List<String> getLastFailedRevisionErrors();
    public String getLastFailedRevisionError(int index);
    public String getFirstLastFailedRevisionError();
    public String getLastLastFailedRevisionError();
    public String getMatchingLastFailedRevisionError(Predicate<String> predicate);
    public Boolean hasMatchingLastFailedRevisionError(Predicate<String> predicate);
    public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors);
    public A withLastFailedRevisionErrors(String... lastFailedRevisionErrors);
    public Boolean hasLastFailedRevisionErrors();
    public A addNewLastFailedRevisionError(StringBuilder arg1);
    public A addNewLastFailedRevisionError(int[] arg1,int arg2,int arg3);
    public A addNewLastFailedRevisionError(char[] arg1);
    public A addNewLastFailedRevisionError(StringBuffer arg1);
    public A addNewLastFailedRevisionError(byte[] arg1,int arg2);
    public A addNewLastFailedRevisionError(byte[] arg1);
    public A addNewLastFailedRevisionError(char[] arg1,int arg2,int arg3);
    public A addNewLastFailedRevisionError(byte[] arg1,int arg2,int arg3);
    public A addNewLastFailedRevisionError(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewLastFailedRevisionError(String arg1);
    public String getNodeName();
    public A withNodeName(String nodeName);
    public Boolean hasNodeName();
    public A withNewNodeName(StringBuilder arg1);
    public A withNewNodeName(int[] arg1,int arg2,int arg3);
    public A withNewNodeName(char[] arg1);
    public A withNewNodeName(StringBuffer arg1);
    public A withNewNodeName(byte[] arg1,int arg2);
    public A withNewNodeName(byte[] arg1);
    public A withNewNodeName(char[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3);
    public A withNewNodeName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewNodeName(String arg1);
    public Integer getTargetRevision();
    public A withTargetRevision(Integer targetRevision);
    public Boolean hasTargetRevision();
    public A withNewTargetRevision(int arg0);
}
