package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftAPIServerSpecBuilder extends OpenShiftAPIServerSpecFluentImpl<OpenShiftAPIServerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<OpenShiftAPIServerSpec,OpenShiftAPIServerSpecBuilder> {

    OpenShiftAPIServerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftAPIServerSpecBuilder() {
        this(true);
    }

    public OpenShiftAPIServerSpecBuilder(Boolean validationEnabled) {
        this(new OpenShiftAPIServerSpec(), validationEnabled);
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new OpenShiftAPIServerSpec(), validationEnabled);
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,OpenShiftAPIServerSpec instance) {
        this(fluent, instance, true);
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpecFluent<?> fluent,OpenShiftAPIServerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpec instance) {
        this(instance,true);
    }

    public OpenShiftAPIServerSpecBuilder(OpenShiftAPIServerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public OpenShiftAPIServerSpec build() {
        OpenShiftAPIServerSpec buildable = new OpenShiftAPIServerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftAPIServerSpecBuilder that = (OpenShiftAPIServerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
