package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCAListBuilder extends ServiceCAListFluentImpl<ServiceCAListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ServiceCAList,ServiceCAListBuilder> {

    ServiceCAListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCAListBuilder() {
        this(true);
    }

    public ServiceCAListBuilder(Boolean validationEnabled) {
        this(new ServiceCAList(), validationEnabled);
    }

    public ServiceCAListBuilder(ServiceCAListFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceCAList(), validationEnabled);
    }

    public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,ServiceCAList instance) {
        this(fluent, instance, true);
    }

    public ServiceCAListBuilder(ServiceCAListFluent<?> fluent,ServiceCAList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCAListBuilder(ServiceCAList instance) {
        this(instance,true);
    }

    public ServiceCAListBuilder(ServiceCAList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCAList build() {
        ServiceCAList buildable = new ServiceCAList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCAListBuilder that = (ServiceCAListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
