package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogAPIServerSpecBuilder extends ServiceCatalogAPIServerSpecFluentImpl<ServiceCatalogAPIServerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ServiceCatalogAPIServerSpec,ServiceCatalogAPIServerSpecBuilder> {

    ServiceCatalogAPIServerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogAPIServerSpecBuilder() {
        this(true);
    }

    public ServiceCatalogAPIServerSpecBuilder(Boolean validationEnabled) {
        this(new ServiceCatalogAPIServerSpec(), validationEnabled);
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceCatalogAPIServerSpec(), validationEnabled);
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,ServiceCatalogAPIServerSpec instance) {
        this(fluent, instance, true);
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,ServiceCatalogAPIServerSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpec instance) {
        this(instance,true);
    }

    public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceCatalogAPIServerSpec build() {
        ServiceCatalogAPIServerSpec buildable = new ServiceCatalogAPIServerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogAPIServerSpecBuilder that = (ServiceCatalogAPIServerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
