package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class AccessLoggingFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent<A> {

    private io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder destination;
    private java.util.List<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>();
    private io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
    private java.lang.String httpLogFormat;

    public AccessLoggingFluentImpl() {
    }

    public AccessLoggingFluentImpl(io.fabric8.openshift.api.model.operator.v1.AccessLogging instance) {
        this.withDestination(instance.getDestination()); 
        this.withHttpCaptureCookies(instance.getHttpCaptureCookies()); 
        this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders()); 
        this.withHttpLogFormat(instance.getHttpLogFormat()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDestination instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.LoggingDestination getDestination() {
        return this.destination!=null?this.destination.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.LoggingDestination buildDestination() {
        return this.destination!=null?this.destination.build():null;
    }

    public A withDestination(io.fabric8.openshift.api.model.operator.v1.LoggingDestination destination) {
        _visitables.get("destination").remove(this.destination);
        if (destination!=null){ this.destination= new io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder(destination); _visitables.get("destination").add(this.destination);} return (A) this;
    }

    public java.lang.Boolean hasDestination() {
        return this.destination != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<A> withNewDestination() {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.DestinationNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<A> withNewDestinationLike(io.fabric8.openshift.api.model.operator.v1.LoggingDestination item) {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.DestinationNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<A> editDestination() {
        return withNewDestinationLike(getDestination());
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<A> editOrNewDestination() {
        return withNewDestinationLike(getDestination() != null ? getDestination(): new io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<A> editOrNewDestinationLike(io.fabric8.openshift.api.model.operator.v1.LoggingDestination item) {
        return withNewDestinationLike(getDestination() != null ? getDestination(): item);
    }

    public A addToHttpCaptureCookies(int index,io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(index >= 0 ? index : _visitables.get("httpCaptureCookies").size(), builder);this.httpCaptureCookies.add(index >= 0 ? index : httpCaptureCookies.size(), builder); return (A)this;
    }

    public A setToHttpCaptureCookies(int index,io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= _visitables.get("httpCaptureCookies").size()) { _visitables.get("httpCaptureCookies").add(builder); } else { _visitables.get("httpCaptureCookies").set(index, builder);}
        if (index < 0 || index >= httpCaptureCookies.size()) { httpCaptureCookies.add(builder); } else { httpCaptureCookies.set(index, builder);}
         return (A)this;
    }

    public A addToHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... items) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item : items) {io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
    }

    public A addAllToHttpCaptureCookies(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item : items) {io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
    }

    public A removeFromHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... items) {
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item : items) {io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
    }

    public A removeAllFromHttpCaptureCookies(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie> items) {
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item : items) {io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHttpCaptureCookies(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> predicate) {
        if (httpCaptureCookies == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> each = httpCaptureCookies.iterator();
        final List visitables = _visitables.get("httpCaptureCookies");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHttpCaptureCookies instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie> getHttpCaptureCookies() {
        return build(httpCaptureCookies);
    }

    public java.util.List<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
        return build(httpCaptureCookies);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(int index) {
        return this.httpCaptureCookies.get(index).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
        return this.httpCaptureCookies.get(0).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
        return this.httpCaptureCookies.get(httpCaptureCookies.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingHttpCaptureCooky(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHttpCaptureCookies(java.util.List<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
        if (this.httpCaptureCookies != null) { _visitables.get("httpCaptureCookies").removeAll(this.httpCaptureCookies);}
        if (httpCaptureCookies != null) {this.httpCaptureCookies = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item : httpCaptureCookies){this.addToHttpCaptureCookies(item);}} else { this.httpCaptureCookies = null;} return (A) this;
    }

    public A withHttpCaptureCookies(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie... httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {this.httpCaptureCookies.clear();}
        if (httpCaptureCookies != null) {for (io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item :httpCaptureCookies){ this.addToHttpCaptureCookies(item);}} return (A) this;
    }

    public java.lang.Boolean hasHttpCaptureCookies() {
        return httpCaptureCookies != null && !httpCaptureCookies.isEmpty();
    }

    public A addNewHttpCaptureCooky(java.lang.String matchType,java.lang.Integer maxLength,java.lang.String name,java.lang.String namePrefix) {
        return (A)addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item) {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(int index,io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item) {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.HttpCaptureCookiesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> editHttpCaptureCooky(int index) {
        if (httpCaptureCookies.size() <= index) throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
        if (httpCaptureCookies.size() == 0) throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
        return setNewHttpCaptureCookyLike(0, buildHttpCaptureCooky(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
        int index = httpCaptureCookies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder> predicate) {
        int index = -1;
        for (int i=0;i<httpCaptureCookies.size();i++) { 
        if (predicate.test(httpCaptureCookies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHttpCaptureHeaders instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders getHttpCaptureHeaders() {
        return this.httpCaptureHeaders!=null?this.httpCaptureHeaders.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
        return this.httpCaptureHeaders!=null?this.httpCaptureHeaders.build():null;
    }

    public A withHttpCaptureHeaders(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
        _visitables.get("httpCaptureHeaders").remove(this.httpCaptureHeaders);
        if (httpCaptureHeaders!=null){ this.httpCaptureHeaders= new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders); _visitables.get("httpCaptureHeaders").add(this.httpCaptureHeaders);} return (A) this;
    }

    public java.lang.Boolean hasHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.HttpCaptureHeadersNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders item) {
        return new io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluentImpl.HttpCaptureHeadersNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders());
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders item) {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): item);
    }

    public java.lang.String getHttpLogFormat() {
        return this.httpLogFormat;
    }

    public A withHttpLogFormat(java.lang.String httpLogFormat) {
        this.httpLogFormat=httpLogFormat; return (A) this;
    }

    public java.lang.Boolean hasHttpLogFormat() {
        return this.httpLogFormat != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHttpLogFormat instead.
     */
        public A withNewHttpLogFormat(java.lang.String arg0) {
        return (A)withHttpLogFormat(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccessLoggingFluentImpl that = (AccessLoggingFluentImpl) o;
        if (destination != null ? !destination.equals(that.destination) :that.destination != null) return false;
        if (httpCaptureCookies != null ? !httpCaptureCookies.equals(that.httpCaptureCookies) :that.httpCaptureCookies != null) return false;
        if (httpCaptureHeaders != null ? !httpCaptureHeaders.equals(that.httpCaptureHeaders) :that.httpCaptureHeaders != null) return false;
        if (httpLogFormat != null ? !httpLogFormat.equals(that.httpLogFormat) :that.httpLogFormat != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(destination,  httpCaptureCookies,  httpCaptureHeaders,  httpLogFormat,  super.hashCode());
    }

    public class DestinationNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.LoggingDestinationFluentImpl<io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<N>> implements io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.DestinationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder builder;

            DestinationNestedImpl(io.fabric8.openshift.api.model.operator.v1.LoggingDestination item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder(this, item);
                        
            }

            DestinationNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.LoggingDestinationBuilder(this);
                        
            }

            public N and() {
                return (N) AccessLoggingFluentImpl.this.withDestination(builder.build());
            }

            public N endDestination() {
                return and();
            }
    }


    public class HttpCaptureCookiesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieFluentImpl<io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureCookiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder builder;
        private final int index;

            HttpCaptureCookiesNestedImpl(int index,io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookie item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(this, item);
                        
            }

            HttpCaptureCookiesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPCookieBuilder(this);
                        
            }

            public N and() {
                return (N) AccessLoggingFluentImpl.this.setToHttpCaptureCookies(index,builder.build());
            }

            public N endHttpCaptureCooky() {
                return and();
            }
    }


    public class HttpCaptureHeadersNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersFluentImpl<io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<N>> implements io.fabric8.openshift.api.model.operator.v1.AccessLoggingFluent.HttpCaptureHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder builder;

            HttpCaptureHeadersNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeaders item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder(this, item);
                        
            }

            HttpCaptureHeadersNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeadersBuilder(this);
                        
            }

            public N and() {
                return (N) AccessLoggingFluentImpl.this.withHttpCaptureHeaders(builder.build());
            }

            public N endHttpCaptureHeaders() {
                return and();
            }
    }


}
