package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleCustomizationBuilder extends io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization,io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleCustomizationBuilder() {
        this(true);
    }

    public ConsoleCustomizationBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleCustomization(), validationEnabled);
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleCustomization(), validationEnabled);
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization instance) {
        this(fluent, instance, true);
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBrand(instance.getBrand()); 
        fluent.withCustomLogoFile(instance.getCustomLogoFile()); 
        fluent.withCustomProductName(instance.getCustomProductName()); 
        fluent.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization instance) {
        this(instance,true);
    }

    public ConsoleCustomizationBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBrand(instance.getBrand()); 
        this.withCustomLogoFile(instance.getCustomLogoFile()); 
        this.withCustomProductName(instance.getCustomProductName()); 
        this.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization build() {
        ConsoleCustomization buildable = new ConsoleCustomization(fluent.getBrand(),fluent.getCustomLogoFile(),fluent.getCustomProductName(),fluent.getDocumentationBaseURL());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleCustomizationBuilder that = (ConsoleCustomizationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
