package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.ConfigMapFileReferenceFluentImpl;

public class ConsoleCustomizationFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent<A> {

    private java.lang.String brand;
    private io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder customLogoFile;
    private java.lang.String customProductName;
    private java.lang.String documentationBaseURL;

    public ConsoleCustomizationFluentImpl() {
    }

    public ConsoleCustomizationFluentImpl(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization instance) {
        this.withBrand(instance.getBrand()); 
        this.withCustomLogoFile(instance.getCustomLogoFile()); 
        this.withCustomProductName(instance.getCustomProductName()); 
        this.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
    }

    public java.lang.String getBrand() {
        return this.brand;
    }

    public A withBrand(java.lang.String brand) {
        this.brand=brand; return (A) this;
    }

    public java.lang.Boolean hasBrand() {
        return this.brand != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBrand instead.
     */
        public A withNewBrand(java.lang.String arg0) {
        return (A)withBrand(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCustomLogoFile instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.ConfigMapFileReference getCustomLogoFile() {
        return this.customLogoFile!=null?this.customLogoFile.build():null;
    }

    public io.fabric8.openshift.api.model.ConfigMapFileReference buildCustomLogoFile() {
        return this.customLogoFile!=null?this.customLogoFile.build():null;
    }

    public A withCustomLogoFile(io.fabric8.openshift.api.model.ConfigMapFileReference customLogoFile) {
        _visitables.get("customLogoFile").remove(this.customLogoFile);
        if (customLogoFile!=null){ this.customLogoFile= new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(customLogoFile); _visitables.get("customLogoFile").add(this.customLogoFile);} return (A) this;
    }

    public java.lang.Boolean hasCustomLogoFile() {
        return this.customLogoFile != null;
    }

    public A withNewCustomLogoFile(java.lang.String key,java.lang.String name) {
        return (A)withCustomLogoFile(new ConfigMapFileReference(key, name));
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFile() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluentImpl.CustomLogoFileNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> withNewCustomLogoFileLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluentImpl.CustomLogoFileNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editCustomLogoFile() {
        return withNewCustomLogoFileLike(getCustomLogoFile());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFile() {
        return withNewCustomLogoFileLike(getCustomLogoFile() != null ? getCustomLogoFile(): new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<A> editOrNewCustomLogoFileLike(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
        return withNewCustomLogoFileLike(getCustomLogoFile() != null ? getCustomLogoFile(): item);
    }

    public java.lang.String getCustomProductName() {
        return this.customProductName;
    }

    public A withCustomProductName(java.lang.String customProductName) {
        this.customProductName=customProductName; return (A) this;
    }

    public java.lang.Boolean hasCustomProductName() {
        return this.customProductName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCustomProductName instead.
     */
        public A withNewCustomProductName(java.lang.String arg0) {
        return (A)withCustomProductName(new String(arg0));
    }

    public java.lang.String getDocumentationBaseURL() {
        return this.documentationBaseURL;
    }

    public A withDocumentationBaseURL(java.lang.String documentationBaseURL) {
        this.documentationBaseURL=documentationBaseURL; return (A) this;
    }

    public java.lang.Boolean hasDocumentationBaseURL() {
        return this.documentationBaseURL != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDocumentationBaseURL instead.
     */
        public A withNewDocumentationBaseURL(java.lang.String arg0) {
        return (A)withDocumentationBaseURL(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleCustomizationFluentImpl that = (ConsoleCustomizationFluentImpl) o;
        if (brand != null ? !brand.equals(that.brand) :that.brand != null) return false;
        if (customLogoFile != null ? !customLogoFile.equals(that.customLogoFile) :that.customLogoFile != null) return false;
        if (customProductName != null ? !customProductName.equals(that.customProductName) :that.customProductName != null) return false;
        if (documentationBaseURL != null ? !documentationBaseURL.equals(that.documentationBaseURL) :that.documentationBaseURL != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(brand,  customLogoFile,  customProductName,  documentationBaseURL,  super.hashCode());
    }

    public class CustomLogoFileNestedImpl<N> extends io.fabric8.openshift.api.model.ConfigMapFileReferenceFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluent.CustomLogoFileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder builder;

            CustomLogoFileNestedImpl(io.fabric8.openshift.api.model.ConfigMapFileReference item) {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(this, item);
                        
            }

            CustomLogoFileNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.ConfigMapFileReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleCustomizationFluentImpl.this.withCustomLogoFile(builder.build());
            }

            public N endCustomLogoFile() {
                return and();
            }
    }


}
