package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleListBuilder extends io.fabric8.openshift.api.model.operator.v1.ConsoleListFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ConsoleList,io.fabric8.openshift.api.model.operator.v1.ConsoleListBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ConsoleListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConsoleListBuilder() {
        this(true);
    }

    public ConsoleListBuilder(java.lang.Boolean validationEnabled) {
        this(new ConsoleList(), validationEnabled);
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleListFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConsoleList(), validationEnabled);
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleList instance) {
        this(fluent, instance, true);
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleListFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ConsoleList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleList instance) {
        this(instance,true);
    }

    public ConsoleListBuilder(io.fabric8.openshift.api.model.operator.v1.ConsoleList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleList build() {
        ConsoleList buildable = new ConsoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleListBuilder that = (ConsoleListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
