package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public class ConsoleSpecFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent<A> {

    private io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder customization;
    private java.lang.String logLevel;
    private java.lang.String managementState;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> observedConfig;
    private java.lang.String operatorLogLevel;
    private io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder providers;
    private io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder route;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> unsupportedConfigOverrides;

    public ConsoleSpecFluentImpl() {
    }

    public ConsoleSpecFluentImpl(io.fabric8.openshift.api.model.operator.v1.ConsoleSpec instance) {
        this.withCustomization(instance.getCustomization()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withProviders(instance.getProviders()); 
        this.withRoute(instance.getRoute()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCustomization instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization getCustomization() {
        return this.customization!=null?this.customization.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization buildCustomization() {
        return this.customization!=null?this.customization.build():null;
    }

    public A withCustomization(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization customization) {
        _visitables.get("customization").remove(this.customization);
        if (customization!=null){ this.customization= new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder(customization); _visitables.get("customization").add(this.customization);} return (A) this;
    }

    public java.lang.Boolean hasCustomization() {
        return this.customization != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<A> withNewCustomization() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CustomizationNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<A> withNewCustomizationLike(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CustomizationNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<A> editCustomization() {
        return withNewCustomizationLike(getCustomization());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<A> editOrNewCustomization() {
        return withNewCustomizationLike(getCustomization() != null ? getCustomization(): new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<A> editOrNewCustomizationLike(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization item) {
        return withNewCustomizationLike(getCustomization() != null ? getCustomization(): item);
    }

    public java.lang.String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(java.lang.String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public java.lang.Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogLevel instead.
     */
        public A withNewLogLevel(java.lang.String arg0) {
        return (A)withLogLevel(new String(arg0));
    }

    public java.lang.String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(java.lang.String managementState) {
        this.managementState=managementState; return (A) this;
    }

    public java.lang.Boolean hasManagementState() {
        return this.managementState != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withManagementState instead.
     */
        public A withNewManagementState(java.lang.String arg0) {
        return (A)withManagementState(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildObservedConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.HasMetadata getObservedConfig() {
        return this.observedConfig!=null?this.observedConfig.build():null;
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildObservedConfig() {
        return this.observedConfig!=null?this.observedConfig.build():null;
    }

    public A withObservedConfig(io.fabric8.kubernetes.api.model.HasMetadata observedConfig) {
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ImagePruner){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder((io.fabric8.openshift.api.model.operator.v1.ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder((io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCA){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.observedConfig= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.IngressController){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder((io.fabric8.openshift.api.model.operator.v1.IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder((io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Console){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder((io.fabric8.openshift.api.model.operator.v1.Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Etcd){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder((io.fabric8.openshift.api.model.operator.v1.Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.KubeScheduler){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Network){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder((io.fabric8.openshift.api.model.operator.v1.Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.CSISnapshotController){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder((io.fabric8.openshift.api.model.operator.v1.CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.DNS){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder((io.fabric8.openshift.api.model.operator.v1.DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.DNSRecord){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder((io.fabric8.openshift.api.model.operator.v1.DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof io.fabric8.openshift.api.model.operator.v1.Authentication){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder((io.fabric8.openshift.api.model.operator.v1.Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasObservedConfig() {
        return this.observedConfig != null;
    }

    public A withImagePrunerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ImagePruner imagePrunerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (imagePrunerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImagePrunerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImagePrunerObservedConfigNestedImpl(item);
    }

    public A withKubeControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager kubeControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeControllerManagerObservedConfigNestedImpl(item);
    }

    public A withImageContentSourcePolicyObservedConfig(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImageContentSourcePolicyObservedConfigNestedImpl(item);
    }

    public A withServiceCAObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCA serviceCAObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCAObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCAObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCAObservedConfigNestedImpl(item);
    }

    public A withPersistentVolumeClaimObservedConfig(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.PersistentVolumeClaimObservedConfigNestedImpl(item);
    }

    public A withKubeAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer kubeAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeAPIServerObservedConfigNestedImpl(item);
    }

    public A withIngressControllerObservedConfig(io.fabric8.openshift.api.model.operator.v1.IngressController ingressControllerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (ingressControllerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.IngressControllerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.IngressControllerObservedConfigNestedImpl(item);
    }

    public A withKubeStorageVersionMigratorObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeStorageVersionMigratorObservedConfigNestedImpl(item);
    }

    public A withConsoleObservedConfig(io.fabric8.openshift.api.model.operator.v1.Console consoleObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (consoleObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ConsoleObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Console item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ConsoleObservedConfigNestedImpl(item);
    }

    public A withOpenShiftControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftControllerManagerObservedConfigNestedImpl(item);
    }

    public A withEtcdObservedConfig(io.fabric8.openshift.api.model.operator.v1.Etcd etcdObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (etcdObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.EtcdObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.EtcdObservedConfigNestedImpl(item);
    }

    public A withKubeSchedulerObservedConfig(io.fabric8.openshift.api.model.operator.v1.KubeScheduler kubeSchedulerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeSchedulerObservedConfigNestedImpl(item);
    }

    public A withNetworkObservedConfig(io.fabric8.openshift.api.model.operator.v1.Network networkObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (networkObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.NetworkObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Network item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.NetworkObservedConfigNestedImpl(item);
    }

    public A withServiceCatalogAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogAPIServerObservedConfigNestedImpl(item);
    }

    public A withCSISnapshotControllerObservedConfig(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController cSISnapshotControllerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CSISnapshotControllerObservedConfigNestedImpl(item);
    }

    public A withServiceCatalogControllerManagerObservedConfig(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
    }

    public A withDNSObservedConfig(io.fabric8.openshift.api.model.operator.v1.DNS dNSObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (dNSObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.DNS item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSObservedConfigNestedImpl(item);
    }

    public A withDNSRecordObservedConfig(io.fabric8.openshift.api.model.operator.v1.DNSRecord dNSRecordObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (dNSRecordObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSRecordObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSRecordObservedConfigNestedImpl(item);
    }

    public A withOpenShiftAPIServerObservedConfig(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer openShiftAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftAPIServerObservedConfigNestedImpl(item);
    }

    public A withAuthenticationObservedConfig(io.fabric8.openshift.api.model.operator.v1.Authentication authenticationObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (authenticationObservedConfig!=null){ this.observedConfig= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.AuthenticationObservedConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.AuthenticationObservedConfigNestedImpl(item);
    }

    public java.lang.String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public A withOperatorLogLevel(java.lang.String operatorLogLevel) {
        this.operatorLogLevel=operatorLogLevel; return (A) this;
    }

    public java.lang.Boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOperatorLogLevel instead.
     */
        public A withNewOperatorLogLevel(java.lang.String arg0) {
        return (A)withOperatorLogLevel(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildProviders instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.ConsoleProviders getProviders() {
        return this.providers!=null?this.providers.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleProviders buildProviders() {
        return this.providers!=null?this.providers.build():null;
    }

    public A withProviders(io.fabric8.openshift.api.model.operator.v1.ConsoleProviders providers) {
        _visitables.get("providers").remove(this.providers);
        if (providers!=null){ this.providers= new io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder(providers); _visitables.get("providers").add(this.providers);} return (A) this;
    }

    public java.lang.Boolean hasProviders() {
        return this.providers != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<A> withNewProviders() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ProvidersNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<A> withNewProvidersLike(io.fabric8.openshift.api.model.operator.v1.ConsoleProviders item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ProvidersNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<A> editProviders() {
        return withNewProvidersLike(getProviders());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<A> editOrNewProviders() {
        return withNewProvidersLike(getProviders() != null ? getProviders(): new io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<A> editOrNewProvidersLike(io.fabric8.openshift.api.model.operator.v1.ConsoleProviders item) {
        return withNewProvidersLike(getProviders() != null ? getProviders(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRoute instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute getRoute() {
        return this.route!=null?this.route.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute buildRoute() {
        return this.route!=null?this.route.build():null;
    }

    public A withRoute(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute route) {
        _visitables.get("route").remove(this.route);
        if (route!=null){ this.route= new io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder(route); _visitables.get("route").add(this.route);} return (A) this;
    }

    public java.lang.Boolean hasRoute() {
        return this.route != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<A> withNewRoute() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.RouteNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<A> withNewRouteLike(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.RouteNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<A> editRoute() {
        return withNewRouteLike(getRoute());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<A> editOrNewRoute() {
        return withNewRouteLike(getRoute() != null ? getRoute(): new io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<A> editOrNewRouteLike(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute item) {
        return withNewRouteLike(getRoute() != null ? getRoute(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.HasMetadata getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
    }

    public A withUnsupportedConfigOverrides(io.fabric8.kubernetes.api.model.HasMetadata unsupportedConfigOverrides) {
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ImagePruner){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder((io.fabric8.openshift.api.model.operator.v1.ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder((io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCA){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.unsupportedConfigOverrides= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.IngressController){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder((io.fabric8.openshift.api.model.operator.v1.IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder((io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Console){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder((io.fabric8.openshift.api.model.operator.v1.Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Etcd){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder((io.fabric8.openshift.api.model.operator.v1.Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.KubeScheduler){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder((io.fabric8.openshift.api.model.operator.v1.KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Network){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder((io.fabric8.openshift.api.model.operator.v1.Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.CSISnapshotController){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder((io.fabric8.openshift.api.model.operator.v1.CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder((io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.DNS){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder((io.fabric8.openshift.api.model.operator.v1.DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.DNSRecord){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder((io.fabric8.openshift.api.model.operator.v1.DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder((io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof io.fabric8.openshift.api.model.operator.v1.Authentication){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder((io.fabric8.openshift.api.model.operator.v1.Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        return (A) this;
    }

    public java.lang.Boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    public A withImagePrunerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ImagePruner imagePrunerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withImageContentSourcePolicyUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCAUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCA serviceCAUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCAUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withPersistentVolumeClaimUnsupportedConfigOverrides(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withIngressControllerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.IngressController ingressControllerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.IngressControllerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withConsoleUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Console consoleUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Console item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ConsoleUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withEtcdUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Etcd etcdUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.EtcdUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeSchedulerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withNetworkUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Network networkUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Network item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.NetworkUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withCSISnapshotControllerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withDNSUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.DNS dNSUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.DNS item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withDNSRecordUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.DNSRecord dNSRecordUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.DNSRecordUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withOpenShiftAPIServerUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withAuthenticationUnsupportedConfigOverrides(io.fabric8.openshift.api.model.operator.v1.Authentication authenticationUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
        return new io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl.AuthenticationUnsupportedConfigOverridesNestedImpl(item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleSpecFluentImpl that = (ConsoleSpecFluentImpl) o;
        if (customization != null ? !customization.equals(that.customization) :that.customization != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
        if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
        if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
        if (providers != null ? !providers.equals(that.providers) :that.providers != null) return false;
        if (route != null ? !route.equals(that.route) :that.route != null) return false;
        if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(customization,  logLevel,  managementState,  observedConfig,  operatorLogLevel,  providers,  route,  unsupportedConfigOverrides,  super.hashCode());
    }

    public class CustomizationNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CustomizationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder builder;

            CustomizationNestedImpl(io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder(this, item);
                        
            }

            CustomizationNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleCustomizationBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withCustomization(builder.build());
            }

            public N endCustomization() {
                return and();
            }
    }


    public class ImagePrunerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ImagePrunerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder builder;

            ImagePrunerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this, item);
                        
            }

            ImagePrunerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endImagePrunerObservedConfig() {
                return and();
            }
    }


    public class KubeControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder builder;

            KubeControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this, item);
                        
            }

            KubeControllerManagerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endKubeControllerManagerObservedConfig() {
                return and();
            }
    }


    public class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder builder;

            ImageContentSourcePolicyObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this, item);
                        
            }

            ImageContentSourcePolicyObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endImageContentSourcePolicyObservedConfig() {
                return and();
            }
    }


    public class ServiceCAObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCAFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder builder;

            ServiceCAObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this, item);
                        
            }

            ServiceCAObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endServiceCAObservedConfig() {
                return and();
            }
    }


    public class PersistentVolumeClaimObservedConfigNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimObservedConfigNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimObservedConfigNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endPersistentVolumeClaimObservedConfig() {
                return and();
            }
    }


    public class KubeAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder builder;

            KubeAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this, item);
                        
            }

            KubeAPIServerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endKubeAPIServerObservedConfig() {
                return and();
            }
    }


    public class IngressControllerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder builder;

            IngressControllerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this, item);
                        
            }

            IngressControllerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endIngressControllerObservedConfig() {
                return and();
            }
    }


    public class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder builder;

            KubeStorageVersionMigratorObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this, item);
                        
            }

            KubeStorageVersionMigratorObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endKubeStorageVersionMigratorObservedConfig() {
                return and();
            }
    }


    public class ConsoleObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder builder;

            ConsoleObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Console item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this, item);
                        
            }

            ConsoleObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endConsoleObservedConfig() {
                return and();
            }
    }


    public class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder builder;

            OpenShiftControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this, item);
                        
            }

            OpenShiftControllerManagerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endOpenShiftControllerManagerObservedConfig() {
                return and();
            }
    }


    public class EtcdObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.EtcdBuilder builder;

            EtcdObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this, item);
                        
            }

            EtcdObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endEtcdObservedConfig() {
                return and();
            }
    }


    public class KubeSchedulerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeSchedulerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder builder;

            KubeSchedulerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this, item);
                        
            }

            KubeSchedulerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endKubeSchedulerObservedConfig() {
                return and();
            }
    }


    public class NetworkObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.NetworkBuilder builder;

            NetworkObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Network item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this, item);
                        
            }

            NetworkObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endNetworkObservedConfig() {
                return and();
            }
    }


    public class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder builder;

            ServiceCatalogAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this, item);
                        
            }

            ServiceCatalogAPIServerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endServiceCatalogAPIServerObservedConfig() {
                return and();
            }
    }


    public class CSISnapshotControllerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder builder;

            CSISnapshotControllerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this, item);
                        
            }

            CSISnapshotControllerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endCSISnapshotControllerObservedConfig() {
                return and();
            }
    }


    public class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder builder;

            ServiceCatalogControllerManagerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this, item);
                        
            }

            ServiceCatalogControllerManagerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endServiceCatalogControllerManagerObservedConfig() {
                return and();
            }
    }


    public class DNSObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DNSBuilder builder;

            DNSObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNS item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this, item);
                        
            }

            DNSObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endDNSObservedConfig() {
                return and();
            }
    }


    public class DNSRecordObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSRecordFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder builder;

            DNSRecordObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this, item);
                        
            }

            DNSRecordObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endDNSRecordObservedConfig() {
                return and();
            }
    }


    public class OpenShiftAPIServerObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder builder;

            OpenShiftAPIServerObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this, item);
                        
            }

            OpenShiftAPIServerObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endOpenShiftAPIServerObservedConfig() {
                return and();
            }
    }


    public class AuthenticationObservedConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AuthenticationFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationObservedConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder builder;

            AuthenticationObservedConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this, item);
                        
            }

            AuthenticationObservedConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withObservedConfig(builder.build());
            }

            public N endAuthenticationObservedConfig() {
                return and();
            }
    }


    public class ProvidersNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ProvidersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder builder;

            ProvidersNestedImpl(io.fabric8.openshift.api.model.operator.v1.ConsoleProviders item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder(this, item);
                        
            }

            ProvidersNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleProvidersBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withProviders(builder.build());
            }

            public N endProviders() {
                return and();
            }
    }


    public class RouteNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder builder;

            RouteNestedImpl(io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRoute item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder(this, item);
                        
            }

            RouteNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleConfigRouteBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withRoute(builder.build());
            }

            public N endRoute() {
                return and();
            }
    }


    public class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ImagePrunerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder builder;

            ImagePrunerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ImagePruner item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this, item);
                        
            }

            ImagePrunerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endImagePrunerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder builder;

            KubeControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this, item);
                        
            }

            KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endKubeControllerManagerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder builder;

            ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this, item);
                        
            }

            ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCAFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder builder;

            ServiceCAUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCA item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this, item);
                        
            }

            ServiceCAUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCABuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endServiceCAUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder builder;

            KubeAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this, item);
                        
            }

            KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endKubeAPIServerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder builder;

            IngressControllerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressController item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this, item);
                        
            }

            IngressControllerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endIngressControllerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder builder;

            KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this, item);
                        
            }

            KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ConsoleFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder builder;

            ConsoleUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Console item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this, item);
                        
            }

            ConsoleUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endConsoleUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder builder;

            OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this, item);
                        
            }

            OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class EtcdUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.EtcdBuilder builder;

            EtcdUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Etcd item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this, item);
                        
            }

            EtcdUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EtcdBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endEtcdUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.KubeSchedulerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder builder;

            KubeSchedulerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.KubeScheduler item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this, item);
                        
            }

            KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.KubeSchedulerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endKubeSchedulerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class NetworkUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NetworkFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.NetworkBuilder builder;

            NetworkUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Network item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this, item);
                        
            }

            NetworkUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NetworkBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endNetworkUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder builder;

            ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this, item);
                        
            }

            ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder builder;

            CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.CSISnapshotController item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this, item);
                        
            }

            CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endCSISnapshotControllerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder builder;

            ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this, item);
                        
            }

            ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class DNSUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DNSBuilder builder;

            DNSUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNS item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this, item);
                        
            }

            DNSUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endDNSUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DNSRecordFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder builder;

            DNSRecordUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.DNSRecord item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this, item);
                        
            }

            DNSRecordUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DNSRecordBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endDNSRecordUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder builder;

            OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this, item);
                        
            }

            OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
                return and();
            }
    }


    public class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AuthenticationFluentImpl<io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder builder;

            AuthenticationUnsupportedConfigOverridesNestedImpl(io.fabric8.openshift.api.model.operator.v1.Authentication item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this, item);
                        
            }

            AuthenticationUnsupportedConfigOverridesNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AuthenticationBuilder(this);
                        
            }

            public N and() {
                return (N) ConsoleSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
            }

            public N endAuthenticationUnsupportedConfigOverrides() {
                return and();
            }
    }


}
