package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSSpecBuilder extends io.fabric8.openshift.api.model.operator.v1.DNSSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.DNSSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.DNSSpec,io.fabric8.openshift.api.model.operator.v1.DNSSpecBuilder> {

    io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DNSSpecBuilder() {
        this(true);
    }

    public DNSSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new DNSSpec(), validationEnabled);
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DNSSpec(), validationEnabled);
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSSpec instance) {
        this(fluent, instance, true);
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.DNSSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withServers(instance.getServers()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpec instance) {
        this(instance,true);
    }

    public DNSSpecBuilder(io.fabric8.openshift.api.model.operator.v1.DNSSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withServers(instance.getServers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.DNSSpec build() {
        DNSSpec buildable = new DNSSpec(fluent.getServers());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSSpecBuilder that = (DNSSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
