package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EtcdSpecBuilder extends io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluentImpl<io.fabric8.openshift.api.model.operator.v1.EtcdSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.EtcdSpec,io.fabric8.openshift.api.model.operator.v1.EtcdSpecBuilder> {

    io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EtcdSpecBuilder() {
        this(true);
    }

    public EtcdSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new EtcdSpec(), validationEnabled);
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EtcdSpec(), validationEnabled);
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.EtcdSpec instance) {
        this(fluent, instance, true);
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpecFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.EtcdSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpec instance) {
        this(instance,true);
    }

    public EtcdSpecBuilder(io.fabric8.openshift.api.model.operator.v1.EtcdSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.EtcdSpec build() {
        EtcdSpec buildable = new EtcdSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EtcdSpecBuilder that = (EtcdSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
