package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.TLSSecurityProfile;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.TLSSecurityProfileBuilder;
import io.fabric8.openshift.api.model.TLSSecurityProfileFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;

public class IngressControllerSpecFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder defaultCertificate;
    private java.lang.String domain;
    private io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder endpointPublishingStrategy;
    private io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder httpHeaders;
    private io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder logging;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder namespaceSelector;
    private io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder nodePlacement;
    private java.lang.Integer replicas;
    private io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder routeAdmission;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder routeSelector;
    private io.fabric8.openshift.api.model.TLSSecurityProfileBuilder tlsSecurityProfile;

    public IngressControllerSpecFluentImpl() {
    }

    public IngressControllerSpecFluentImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerSpec instance) {
        this.withDefaultCertificate(instance.getDefaultCertificate()); 
        this.withDomain(instance.getDomain()); 
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        this.withHttpHeaders(instance.getHttpHeaders()); 
        this.withLogging(instance.getLogging()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withNodePlacement(instance.getNodePlacement()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRouteAdmission(instance.getRouteAdmission()); 
        this.withRouteSelector(instance.getRouteSelector()); 
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDefaultCertificate instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LocalObjectReference getDefaultCertificate() {
        return this.defaultCertificate!=null?this.defaultCertificate.build():null;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference buildDefaultCertificate() {
        return this.defaultCertificate!=null?this.defaultCertificate.build():null;
    }

    public A withDefaultCertificate(io.fabric8.kubernetes.api.model.LocalObjectReference defaultCertificate) {
        _visitables.get("defaultCertificate").remove(this.defaultCertificate);
        if (defaultCertificate!=null){ this.defaultCertificate= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(defaultCertificate); _visitables.get("defaultCertificate").add(this.defaultCertificate);} return (A) this;
    }

    public java.lang.Boolean hasDefaultCertificate() {
        return this.defaultCertificate != null;
    }

    public A withNewDefaultCertificate(java.lang.String name) {
        return (A)withDefaultCertificate(new LocalObjectReference(name));
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificate() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificateLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.DefaultCertificateNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<A> editDefaultCertificate() {
        return withNewDefaultCertificateLike(getDefaultCertificate());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificate() {
        return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificateLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): item);
    }

    public java.lang.String getDomain() {
        return this.domain;
    }

    public A withDomain(java.lang.String domain) {
        this.domain=domain; return (A) this;
    }

    public java.lang.Boolean hasDomain() {
        return this.domain != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDomain instead.
     */
        public A withNewDomain(java.lang.String arg0) {
        return (A)withDomain(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy getEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy buildEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
    }

    public A withEndpointPublishingStrategy(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy endpointPublishingStrategy) {
        _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} return (A) this;
    }

    public java.lang.Boolean hasEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.EndpointPublishingStrategyNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHttpHeaders instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders getHttpHeaders() {
        return this.httpHeaders!=null?this.httpHeaders.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders buildHttpHeaders() {
        return this.httpHeaders!=null?this.httpHeaders.build():null;
    }

    public A withHttpHeaders(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders httpHeaders) {
        _visitables.get("httpHeaders").remove(this.httpHeaders);
        if (httpHeaders!=null){ this.httpHeaders= new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder(httpHeaders); _visitables.get("httpHeaders").add(this.httpHeaders);} return (A) this;
    }

    public java.lang.Boolean hasHttpHeaders() {
        return this.httpHeaders != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeaders() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.HttpHeadersNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeadersLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.HttpHeadersNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<A> editHttpHeaders() {
        return withNewHttpHeadersLike(getHttpHeaders());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeaders() {
        return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeadersLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders item) {
        return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging logging) {
        _visitables.get("logging").remove(this.logging);
        if (logging!=null){ this.logging= new io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder(logging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<A> withNewLogging() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.LoggingNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<A> withNewLoggingLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.LoggingNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<A> editLogging() {
        return withNewLoggingLike(getLogging());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<A> editOrNewLogging() {
        return withNewLoggingLike(getLogging() != null ? getLogging(): new io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<A> editOrNewLoggingLike(io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging item) {
        return withNewLoggingLike(getLogging() != null ? getLogging(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNamespaceSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public java.lang.Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.NamespaceSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNodePlacement instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.NodePlacement getNodePlacement() {
        return this.nodePlacement!=null?this.nodePlacement.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.NodePlacement buildNodePlacement() {
        return this.nodePlacement!=null?this.nodePlacement.build():null;
    }

    public A withNodePlacement(io.fabric8.openshift.api.model.operator.v1.NodePlacement nodePlacement) {
        _visitables.get("nodePlacement").remove(this.nodePlacement);
        if (nodePlacement!=null){ this.nodePlacement= new io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} return (A) this;
    }

    public java.lang.Boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.NodePlacementNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(io.fabric8.openshift.api.model.operator.v1.NodePlacement item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.NodePlacementNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<A> editNodePlacement() {
        return withNewNodePlacementLike(getNodePlacement());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
        return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(io.fabric8.openshift.api.model.operator.v1.NodePlacement item) {
        return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRouteAdmission instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy getRouteAdmission() {
        return this.routeAdmission!=null?this.routeAdmission.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy buildRouteAdmission() {
        return this.routeAdmission!=null?this.routeAdmission.build():null;
    }

    public A withRouteAdmission(io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy routeAdmission) {
        _visitables.get("routeAdmission").remove(this.routeAdmission);
        if (routeAdmission!=null){ this.routeAdmission= new io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder(routeAdmission); _visitables.get("routeAdmission").add(this.routeAdmission);} return (A) this;
    }

    public java.lang.Boolean hasRouteAdmission() {
        return this.routeAdmission != null;
    }

    public A withNewRouteAdmission(java.lang.String namespaceOwnership,java.lang.String wildcardPolicy) {
        return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmission() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmissionLike(io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.RouteAdmissionNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<A> editRouteAdmission() {
        return withNewRouteAdmissionLike(getRouteAdmission());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmission() {
        return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): new io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmissionLike(io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy item) {
        return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRouteSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getRouteSelector() {
        return this.routeSelector!=null?this.routeSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildRouteSelector() {
        return this.routeSelector!=null?this.routeSelector.build():null;
    }

    public A withRouteSelector(io.fabric8.kubernetes.api.model.LabelSelector routeSelector) {
        _visitables.get("routeSelector").remove(this.routeSelector);
        if (routeSelector!=null){ this.routeSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} return (A) this;
    }

    public java.lang.Boolean hasRouteSelector() {
        return this.routeSelector != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelector() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.RouteSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.RouteSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<A> editRouteSelector() {
        return withNewRouteSelectorLike(getRouteSelector());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelector() {
        return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSecurityProfile instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public io.fabric8.openshift.api.model.TLSSecurityProfile buildTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public A withTlsSecurityProfile(io.fabric8.openshift.api.model.TLSSecurityProfile tlsSecurityProfile) {
        _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
        if (tlsSecurityProfile!=null){ this.tlsSecurityProfile= new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(tlsSecurityProfile); _visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);} return (A) this;
    }

    public java.lang.Boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.TlsSecurityProfileNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
        return new io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluentImpl.TlsSecurityProfileNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressControllerSpecFluentImpl that = (IngressControllerSpecFluentImpl) o;
        if (defaultCertificate != null ? !defaultCertificate.equals(that.defaultCertificate) :that.defaultCertificate != null) return false;
        if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
        if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
        if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (nodePlacement != null ? !nodePlacement.equals(that.nodePlacement) :that.nodePlacement != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (routeAdmission != null ? !routeAdmission.equals(that.routeAdmission) :that.routeAdmission != null) return false;
        if (routeSelector != null ? !routeSelector.equals(that.routeSelector) :that.routeSelector != null) return false;
        if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(defaultCertificate,  domain,  endpointPublishingStrategy,  httpHeaders,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  super.hashCode());
    }

    public class DefaultCertificateNestedImpl<N> extends io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.DefaultCertificateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;

            DefaultCertificateNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
                        
            }

            DefaultCertificateNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withDefaultCertificate(builder.build());
            }

            public N endDefaultCertificate() {
                return and();
            }
    }


    public class EndpointPublishingStrategyNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder builder;

            EndpointPublishingStrategyNestedImpl(io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(this, item);
                        
            }

            EndpointPublishingStrategyNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withEndpointPublishingStrategy(builder.build());
            }

            public N endEndpointPublishingStrategy() {
                return and();
            }
    }


    public class HttpHeadersNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.HttpHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder builder;

            HttpHeadersNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder(this, item);
                        
            }

            HttpHeadersNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withHttpHeaders(builder.build());
            }

            public N endHttpHeaders() {
                return and();
            }
    }


    public class LoggingNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.LoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder builder;

            LoggingNestedImpl(io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder(this, item);
                        
            }

            LoggingNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endLogging() {
                return and();
            }
    }


    public class NamespaceSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            NamespaceSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            NamespaceSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withNamespaceSelector(builder.build());
            }

            public N endNamespaceSelector() {
                return and();
            }
    }


    public class NodePlacementNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.NodePlacementFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.NodePlacementNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder builder;

            NodePlacementNestedImpl(io.fabric8.openshift.api.model.operator.v1.NodePlacement item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder(this, item);
                        
            }

            NodePlacementNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withNodePlacement(builder.build());
            }

            public N endNodePlacement() {
                return and();
            }
    }


    public class RouteAdmissionNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteAdmissionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder builder;

            RouteAdmissionNestedImpl(io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder(this, item);
                        
            }

            RouteAdmissionNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withRouteAdmission(builder.build());
            }

            public N endRouteAdmission() {
                return and();
            }
    }


    public class RouteSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.RouteSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            RouteSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            RouteSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withRouteSelector(builder.build());
            }

            public N endRouteSelector() {
                return and();
            }
    }


    public class TlsSecurityProfileNestedImpl<N> extends io.fabric8.openshift.api.model.TLSSecurityProfileFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<N>> implements io.fabric8.openshift.api.model.operator.v1.IngressControllerSpecFluent.TlsSecurityProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.TLSSecurityProfileBuilder builder;

            TlsSecurityProfileNestedImpl(io.fabric8.openshift.api.model.TLSSecurityProfile item) {
                this.builder = new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(this, item);
                        
            }

            TlsSecurityProfileNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.TLSSecurityProfileBuilder(this);
                        
            }

            public N and() {
                return (N) IngressControllerSpecFluentImpl.this.withTlsSecurityProfile(builder.build());
            }

            public N endTlsSecurityProfile() {
                return and();
            }
    }


}
