package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerStatusBuilder extends io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluentImpl<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus,io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusBuilder> {

    io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressControllerStatusBuilder() {
        this(true);
    }

    public IngressControllerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressControllerStatus(), validationEnabled);
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressControllerStatus(), validationEnabled);
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus instance) {
        this(fluent, instance, true);
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatusFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withDomain(instance.getDomain()); 
        fluent.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTlsProfile(instance.getTlsProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus instance) {
        this(instance,true);
    }

    public IngressControllerStatusBuilder(io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withConditions(instance.getConditions()); 
        this.withDomain(instance.getDomain()); 
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSelector(instance.getSelector()); 
        this.withTlsProfile(instance.getTlsProfile()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.IngressControllerStatus build() {
        IngressControllerStatus buildable = new IngressControllerStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getDomain(),fluent.getEndpointPublishingStrategy(),fluent.getObservedGeneration(),fluent.getSelector(),fluent.getTlsProfile());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressControllerStatusBuilder that = (IngressControllerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
