package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KuryrConfigBuilder extends io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.KuryrConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.KuryrConfig,io.fabric8.openshift.api.model.operator.v1.KuryrConfigBuilder> {

    io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KuryrConfigBuilder() {
        this(true);
    }

    public KuryrConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new KuryrConfig(), validationEnabled);
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KuryrConfig(), validationEnabled);
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.KuryrConfig instance) {
        this(fluent, instance, true);
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.KuryrConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withControllerProbesPort(instance.getControllerProbesPort()); 
        fluent.withDaemonProbesPort(instance.getDaemonProbesPort()); 
        fluent.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
        fluent.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
        fluent.withPoolBatchPorts(instance.getPoolBatchPorts()); 
        fluent.withPoolMaxPorts(instance.getPoolMaxPorts()); 
        fluent.withPoolMinPorts(instance.getPoolMinPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfig instance) {
        this(instance,true);
    }

    public KuryrConfigBuilder(io.fabric8.openshift.api.model.operator.v1.KuryrConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withControllerProbesPort(instance.getControllerProbesPort()); 
        this.withDaemonProbesPort(instance.getDaemonProbesPort()); 
        this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
        this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
        this.withPoolBatchPorts(instance.getPoolBatchPorts()); 
        this.withPoolMaxPorts(instance.getPoolMaxPorts()); 
        this.withPoolMinPorts(instance.getPoolMinPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.KuryrConfig build() {
        KuryrConfig buildable = new KuryrConfig(fluent.getControllerProbesPort(),fluent.getDaemonProbesPort(),fluent.getEnablePortPoolsPrepopulation(),fluent.getOpenStackServiceNetwork(),fluent.getPoolBatchPorts(),fluent.getPoolMaxPorts(),fluent.getPoolMinPorts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KuryrConfigBuilder that = (KuryrConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
