package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class NetworkSpecFluentImpl<A extends io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent<A> {

    private java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> additionalNetworks =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();
    private java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> clusterNetwork =  new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();
    private io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder defaultNetwork;
    private java.lang.Boolean deployKubeProxy;
    private java.lang.Boolean disableMultiNetwork;
    private io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder kubeProxyConfig;
    private java.lang.String logLevel;
    private java.util.List<java.lang.String> serviceNetwork = new java.util.ArrayList<java.lang.String>();

    public NetworkSpecFluentImpl() {
    }

    public NetworkSpecFluentImpl(io.fabric8.openshift.api.model.operator.v1.NetworkSpec instance) {
        this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
        this.withClusterNetwork(instance.getClusterNetwork()); 
        this.withDefaultNetwork(instance.getDefaultNetwork()); 
        this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
        this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
    }

    public A addToAdditionalNetworks(int index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(index >= 0 ? index : _visitables.get("additionalNetworks").size(), builder);this.additionalNetworks.add(index >= 0 ? index : additionalNetworks.size(), builder); return (A)this;
    }

    public A setToAdditionalNetworks(int index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("additionalNetworks").size()) { _visitables.get("additionalNetworks").add(builder); } else { _visitables.get("additionalNetworks").set(index, builder);}
        if (index < 0 || index >= additionalNetworks.size()) { additionalNetworks.add(builder); } else { additionalNetworks.set(index, builder);}
         return (A)this;
    }

    public A addToAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
    }

    public A addAllToAdditionalNetworks(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> items) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
    }

    public A removeFromAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... items) {
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
    }

    public A removeAllFromAdditionalNetworks(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> items) {
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : items) {io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAdditionalNetworks(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
        if (additionalNetworks == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
        final List visitables = _visitables.get("additionalNetworks");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAdditionalNetworks instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> getAdditionalNetworks() {
        return build(additionalNetworks);
    }

    public java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> buildAdditionalNetworks() {
        return build(additionalNetworks);
    }

    public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildAdditionalNetwork(int index) {
        return this.additionalNetworks.get(index).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
        return this.additionalNetworks.get(0).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildLastAdditionalNetwork() {
        return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition buildMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalNetworks(java.util.List<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition> additionalNetworks) {
        if (this.additionalNetworks != null) { _visitables.get("additionalNetworks").removeAll(this.additionalNetworks);}
        if (additionalNetworks != null) {this.additionalNetworks = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item : additionalNetworks){this.addToAdditionalNetworks(item);}} else { this.additionalNetworks = null;} return (A) this;
    }

    public A withAdditionalNetworks(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition... additionalNetworks) {
        if (this.additionalNetworks != null) {this.additionalNetworks.clear();}
        if (additionalNetworks != null) {for (io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item :additionalNetworks){ this.addToAdditionalNetworks(item);}} return (A) this;
    }

    public java.lang.Boolean hasAdditionalNetworks() {
        return additionalNetworks != null && !additionalNetworks.isEmpty();
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.AdditionalNetworksNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(int index) {
        if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
        if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
        return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
        int index = additionalNetworks.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<additionalNetworks.size();i++) { 
        if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public A addToClusterNetwork(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
    }

    public A setToClusterNetwork(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
        if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
         return (A)this;
    }

    public A addToClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A addAllToClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>();}
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A removeFromClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... items) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterNetwork(java.util.Collection<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> items) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : items) {io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        if (clusterNetwork == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
        final List visitables = _visitables.get("clusterNetwork");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterNetwork instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> getClusterNetwork() {
        return build(clusterNetwork);
    }

    public java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> buildClusterNetwork() {
        return build(clusterNetwork);
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry buildMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusterNetwork(java.util.List<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
        if (clusterNetwork != null) {this.clusterNetwork = new java.util.ArrayList<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder>(); for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
    }

    public A withClusterNetwork(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry... clusterNetwork) {
        if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
        if (clusterNetwork != null) {for (io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
    }

    public java.lang.Boolean hasClusterNetwork() {
        return clusterNetwork != null && !clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(java.lang.String cidr,java.lang.Integer hostPrefix) {
        return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(0, buildClusterNetwork(0));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = clusterNetwork.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(java.util.function.Predicate<io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusterNetwork.size();i++) { 
        if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDefaultNetwork instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition getDefaultNetwork() {
        return this.defaultNetwork!=null?this.defaultNetwork.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition buildDefaultNetwork() {
        return this.defaultNetwork!=null?this.defaultNetwork.build():null;
    }

    public A withDefaultNetwork(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition defaultNetwork) {
        _visitables.get("defaultNetwork").remove(this.defaultNetwork);
        if (defaultNetwork!=null){ this.defaultNetwork= new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(defaultNetwork); _visitables.get("defaultNetwork").add(this.defaultNetwork);} return (A) this;
    }

    public java.lang.Boolean hasDefaultNetwork() {
        return this.defaultNetwork != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DefaultNetworkNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.DefaultNetworkNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
        return withNewDefaultNetworkLike(getDefaultNetwork());
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
        return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
        return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): item);
    }

    public java.lang.Boolean getDeployKubeProxy() {
        return this.deployKubeProxy;
    }

    public A withDeployKubeProxy(java.lang.Boolean deployKubeProxy) {
        this.deployKubeProxy=deployKubeProxy; return (A) this;
    }

    public java.lang.Boolean hasDeployKubeProxy() {
        return this.deployKubeProxy != null;
    }

    public java.lang.Boolean getDisableMultiNetwork() {
        return this.disableMultiNetwork;
    }

    public A withDisableMultiNetwork(java.lang.Boolean disableMultiNetwork) {
        this.disableMultiNetwork=disableMultiNetwork; return (A) this;
    }

    public java.lang.Boolean hasDisableMultiNetwork() {
        return this.disableMultiNetwork != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKubeProxyConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.operator.v1.ProxyConfig getKubeProxyConfig() {
        return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
    }

    public io.fabric8.openshift.api.model.operator.v1.ProxyConfig buildKubeProxyConfig() {
        return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
    }

    public A withKubeProxyConfig(io.fabric8.openshift.api.model.operator.v1.ProxyConfig kubeProxyConfig) {
        _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
        if (kubeProxyConfig!=null){ this.kubeProxyConfig= new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(kubeProxyConfig); _visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);} return (A) this;
    }

    public java.lang.Boolean hasKubeProxyConfig() {
        return this.kubeProxyConfig != null;
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeProxyConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
        return new io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluentImpl.KubeProxyConfigNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
        return withNewKubeProxyConfigLike(getKubeProxyConfig());
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
        return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder().build());
    }

    public io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
        return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): item);
    }

    public java.lang.String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(java.lang.String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public java.lang.Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLogLevel instead.
     */
        public A withNewLogLevel(java.lang.String arg0) {
        return (A)withLogLevel(new String(arg0));
    }

    public A addToServiceNetwork(int index,java.lang.String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public A setToServiceNetwork(int index,java.lang.String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        this.serviceNetwork.set(index, item); return (A)this;
    }

    public A addToServiceNetwork(java.lang.String... items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A addAllToServiceNetwork(java.util.Collection<java.lang.String> items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A removeFromServiceNetwork(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public A removeAllFromServiceNetwork(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public java.lang.String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public java.lang.String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public java.lang.String getLastServiceNetwork() {
        return this.serviceNetwork.get(serviceNetwork.size() - 1);
    }

    public java.lang.String getMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingServiceNetwork(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withServiceNetwork(java.util.List<java.lang.String> serviceNetwork) {
        if (this.serviceNetwork != null) { _visitables.get("serviceNetwork").removeAll(this.serviceNetwork);}
        if (serviceNetwork != null) {this.serviceNetwork = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
    }

    public A withServiceNetwork(java.lang.String... serviceNetwork) {
        if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
        if (serviceNetwork != null) {for (java.lang.String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
    }

    public java.lang.Boolean hasServiceNetwork() {
        return serviceNetwork != null && !serviceNetwork.isEmpty();
    }

    public A addNewServiceNetwork(java.lang.String arg0) {
        return (A)addToServiceNetwork(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
        if (additionalNetworks != null ? !additionalNetworks.equals(that.additionalNetworks) :that.additionalNetworks != null) return false;
        if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
        if (defaultNetwork != null ? !defaultNetwork.equals(that.defaultNetwork) :that.defaultNetwork != null) return false;
        if (deployKubeProxy != null ? !deployKubeProxy.equals(that.deployKubeProxy) :that.deployKubeProxy != null) return false;
        if (disableMultiNetwork != null ? !disableMultiNetwork.equals(that.disableMultiNetwork) :that.disableMultiNetwork != null) return false;
        if (kubeProxyConfig != null ? !kubeProxyConfig.equals(that.kubeProxyConfig) :that.kubeProxyConfig != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalNetworks,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  kubeProxyConfig,  logLevel,  serviceNetwork,  super.hashCode());
    }

    public class AdditionalNetworksNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.AdditionalNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder builder;
        private final int index;

            AdditionalNetworksNestedImpl(int index,io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinition item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(this, item);
                        
            }

            AdditionalNetworksNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.AdditionalNetworkDefinitionBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.setToAdditionalNetworks(index,builder.build());
            }

            public N endAdditionalNetwork() {
                return and();
            }
    }


    public class ClusterNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.ClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder builder;
        private final int index;

            ClusterNetworkNestedImpl(int index,io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntry item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this, item);
                        
            }

            ClusterNetworkNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ClusterNetworkEntryBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
            }

            public N endClusterNetwork() {
                return and();
            }
    }


    public class DefaultNetworkNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.DefaultNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder builder;

            DefaultNetworkNestedImpl(io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinition item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(this, item);
                        
            }

            DefaultNetworkNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.DefaultNetworkDefinitionBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.withDefaultNetwork(builder.build());
            }

            public N endDefaultNetwork() {
                return and();
            }
    }


    public class KubeProxyConfigNestedImpl<N> extends io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<N>> implements io.fabric8.openshift.api.model.operator.v1.NetworkSpecFluent.KubeProxyConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder builder;

            KubeProxyConfigNestedImpl(io.fabric8.openshift.api.model.operator.v1.ProxyConfig item) {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(this, item);
                        
            }

            KubeProxyConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder(this);
                        
            }

            public N and() {
                return (N) NetworkSpecFluentImpl.this.withKubeProxyConfig(builder.build());
            }

            public N endKubeProxyConfig() {
                return and();
            }
    }


}
