package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyConfigBuilder extends io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluentImpl<io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operator.v1.ProxyConfig,io.fabric8.openshift.api.model.operator.v1.ProxyConfigBuilder> {

    io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProxyConfigBuilder() {
        this(true);
    }

    public ProxyConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new ProxyConfig(), validationEnabled);
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ProxyConfig(), validationEnabled);
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ProxyConfig instance) {
        this(fluent, instance, true);
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfigFluent<?> fluent,io.fabric8.openshift.api.model.operator.v1.ProxyConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBindAddress(instance.getBindAddress()); 
        fluent.withIptablesSyncPeriod(instance.getIptablesSyncPeriod()); 
        fluent.withProxyArguments(instance.getProxyArguments()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfig instance) {
        this(instance,true);
    }

    public ProxyConfigBuilder(io.fabric8.openshift.api.model.operator.v1.ProxyConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBindAddress(instance.getBindAddress()); 
        this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod()); 
        this.withProxyArguments(instance.getProxyArguments()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operator.v1.ProxyConfig build() {
        ProxyConfig buildable = new ProxyConfig(fluent.getBindAddress(),fluent.getIptablesSyncPeriod(),fluent.getProxyArguments());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxyConfigBuilder that = (ProxyConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
